/*
 * Decompiled with CFR 0.152.
 */
package vm;

import icecaptools.IcecapCompileMe;
import vm.Machine;
import vm.Scheduler;

public abstract class Monitor {
    public abstract void lock();

    public abstract void unlock();

    protected Monitor() {
    }

    public void attach(Object target) {
        this.attachMonitor(target);
    }

    native void attachMonitor(Object var1);

    protected static native Object getAttachedMonitor(Object var0);

    @IcecapCompileMe
    static void lock(Monitor monitor) {
        monitor.lock();
    }

    @IcecapCompileMe
    static void unlock(Monitor monitor) {
        monitor.unlock();
    }

    @IcecapCompileMe
    public static void wait(Object target) {
        Scheduler sch = Machine.getCurrentScheduler();
        sch.wait(target);
    }

    @IcecapCompileMe
    public static void notify(Object target) {
        Scheduler sch = Machine.getCurrentScheduler();
        sch.notify(target);
    }

    @IcecapCompileMe
    public static void notifyAll(Object target) {
        Scheduler sch = Machine.getCurrentScheduler();
        sch.notifyAll(target);
    }

    @IcecapCompileMe
    public static Monitor getDefaultMonitor() {
        Scheduler sch = Machine.getCurrentScheduler();
        if (sch != null) {
            return sch.getDefaultMonitor();
        }
        return null;
    }
}

