/*
 * Decompiled with CFR 0.152.
 */
package vm;

import devices.Console;
import vm.Memory;
import vm.StackAnalyser;

public class FullStackAnanlyser
implements StackAnalyser {
    private int numberOfStacksCreated;
    static int[][] stacks = new int[10][];
    private static final int USEDSTACKCELL = 10;
    private static final int UNUSEDSTACKCELL = 11;
    private int state;
    private int best_start_of_unused_area;
    private int best_end_of_unused_area;

    @Override
    public void addStack(int[] stack) {
        if (stack != null && this.numberOfStacksCreated < stacks.length) {
            int index = 0;
            while (index < stack.length) {
                stack[index] = index;
                index = (short)(index + 1);
            }
            FullStackAnanlyser.stacks[this.numberOfStacksCreated++] = stack;
        }
    }

    @Override
    public void reportStackUsage() {
        Memory.executeInTrackingArea(new Runnable(){

            @Override
            public void run() {
                Console.println("Created " + FullStackAnanlyser.this.numberOfStacksCreated + " stacks");
                int index = 0;
                while (index < stacks.length) {
                    if (stacks[index] != null) {
                        FullStackAnanlyser.this.analyseStack(stacks[index]);
                        Console.println("stack " + index + "[" + FullStackAnanlyser.this.best_start_of_unused_area + ", " + FullStackAnanlyser.this.best_end_of_unused_area + "][" + stacks[index].length + "]");
                    }
                    index = (byte)(index + 1);
                }
            }
        });
    }

    private void analyseStack(int[] stack) {
        this.state = 10;
        int index = 0;
        int start_of_unused_area = 0;
        int end_of_unused_area = 0;
        this.best_start_of_unused_area = 0;
        this.best_end_of_unused_area = 0;
        while (index < stack.length) {
            switch (this.state) {
                case 10: {
                    if (stack[index] != index) break;
                    start_of_unused_area = index;
                    this.state = 11;
                    break;
                }
                case 11: {
                    if (stack[index] == index) break;
                    end_of_unused_area = index;
                    this.state = 10;
                    this.updateBest(start_of_unused_area, end_of_unused_area);
                }
            }
            ++index;
        }
        if (this.state == 11) {
            this.updateBest(start_of_unused_area, end_of_unused_area);
        }
    }

    private void updateBest(int start_of_unused_area, int end_of_unused_area) {
        if (end_of_unused_area - start_of_unused_area > this.best_end_of_unused_area - this.best_start_of_unused_area) {
            this.best_end_of_unused_area = end_of_unused_area;
            this.best_start_of_unused_area = start_of_unused_area;
        }
    }
}

