/*
 * Decompiled with CFR 0.152.
 */
package minicdj.cdx.unannotated;

import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import minicdj.cdx.Constants;

public class NanoClock {
    public static long baseMillis = -1L;
    public static int baseNanos = -1;

    public static AbsoluteTime roundUp(AbsoluteTime t) {
        long tNanos = t.getNanoseconds();
        long tMillis = t.getMilliseconds();
        long periodMillis = Constants.DETECTOR_PERIOD;
        if (tNanos > 0L) {
            tNanos = 0L;
            ++tMillis;
        }
        if (periodMillis > 0L) {
            tMillis = (tMillis + periodMillis - 1L) / periodMillis * periodMillis;
        }
        return new AbsoluteTime(tMillis, (int)tNanos);
    }

    public static void init() {
        if (baseMillis != -1L || baseNanos != -1) {
            throw new RuntimeException("NanoClock already initialized.");
        }
        AbsoluteTime rt = NanoClock.roundUp(Clock.getRealtimeClock().getTime());
        baseNanos = rt.getNanoseconds();
        baseMillis = rt.getMilliseconds();
    }

    public static long now() {
        AbsoluteTime t = Clock.getRealtimeClock().getTime();
        return NanoClock.convert(t);
    }

    public static long convert(AbsoluteTime t) {
        long millis = t.getMilliseconds() - baseMillis;
        int nanos = t.getNanoseconds();
        return millis * 1000000L + (long)nanos - (long)baseNanos;
    }

    public static int asMicros(long relativeNanos) {
        if (relativeNanos < 0L && relativeNanos == -1L) {
            return 0;
        }
        long millis = baseMillis + relativeNanos / 1000000L;
        int nanos = baseNanos + (int)(relativeNanos % 1000000L);
        millis += (long)nanos / 1000000L;
        return (nanos %= 1000000) / 1000;
    }

    public static String asString(long relativeNanos) {
        if (relativeNanos < 0L && relativeNanos == -1L) {
            return "NA";
        }
        long millis = baseMillis + relativeNanos / 1000000L;
        int nanos = baseNanos + (int)(relativeNanos % 1000000L);
        millis += (long)nanos / 1000000L;
        String ns = Integer.toString(nanos %= 1000000);
        int zeros = 6 - ns.length();
        StringBuffer result = new StringBuffer(Long.toString(millis));
        while (zeros-- > 0) {
            result = result.append("0");
        }
        result = result.append(ns);
        return result.toString();
    }
}

