/*
 * Decompiled with CFR 0.152.
 */
package minicdj.cdx;

import devices.Console;
import minicdj.cdx.Aircraft;
import minicdj.cdx.Benchmarker;
import minicdj.cdx.CallSign;
import minicdj.cdx.Collision;
import minicdj.cdx.Constants;
import minicdj.cdx.ImmortalEntry;
import minicdj.cdx.Motion;
import minicdj.cdx.RawFrame;
import minicdj.cdx.Reducer;
import minicdj.cdx.StateTable;
import minicdj.statetable.Vector3d;
import minicdj.util.HashMap;
import minicdj.util.HashSet;
import minicdj.util.Iterator;
import minicdj.util.LinkedList;
import minicdj.util.List;

public class TransientDetectorScopeEntry
implements Runnable {
    private StateTable state;
    private float voxelSize;
    private RawFrame currentFrame;
    int frameno = -1;
    private final R r = new R();

    public TransientDetectorScopeEntry(StateTable s, float voxelSize) {
        this.state = s;
        this.voxelSize = voxelSize;
    }

    @Override
    public void run() {
        Benchmarker.set(1);
        Benchmarker.set(Benchmarker.RAPITA_REDUCER_INIT);
        Reducer reducer = new Reducer(this.voxelSize);
        Benchmarker.done(Benchmarker.RAPITA_REDUCER_INIT);
        Benchmarker.set(Benchmarker.LOOK_FOR_COLLISIONS);
        int numberOfCollisions = this.lookForCollisions(reducer, this.createMotions());
        Benchmarker.done(Benchmarker.LOOK_FOR_COLLISIONS);
        if (ImmortalEntry.recordedRuns < ImmortalEntry.maxDetectorRuns) {
            ImmortalEntry.detectedCollisions[ImmortalEntry.recordedRuns] = numberOfCollisions;
        }
        if (Constants.SYNCHRONOUS_DETECTOR || Constants.DEBUG_DETECTOR) {
            Console.println("CD detected  " + numberOfCollisions + " collisions.");
            Console.println("");
        }
        Benchmarker.done(1);
    }

    public int lookForCollisions(Reducer reducer, List motions) {
        Benchmarker.set(2);
        List check = this.reduceCollisionSet(reducer, motions);
        int suspectedSize = check.size();
        if (ImmortalEntry.recordedRuns < ImmortalEntry.maxDetectorRuns) {
            ImmortalEntry.suspectedCollisions[ImmortalEntry.recordedRuns] = suspectedSize;
        }
        int c = 0;
        LinkedList ret = new LinkedList();
        Iterator iter = check.iterator();
        while (iter.hasNext()) {
            c += this.determineCollisions((List)iter.next(), ret);
        }
        Benchmarker.done(2);
        return c;
    }

    public List reduceCollisionSet(Reducer it, List motions) {
        Benchmarker.set(3);
        HashMap voxel_map = new HashMap();
        HashMap graph_colors = new HashMap();
        Iterator iter = motions.iterator();
        while (iter.hasNext()) {
            it.performVoxelHashing((Motion)iter.next(), voxel_map, graph_colors);
        }
        LinkedList ret = new LinkedList();
        Iterator iter2 = voxel_map.values().iterator();
        while (iter2.hasNext()) {
            List cur_set = (List)iter2.next();
            if (cur_set.size() <= 1) continue;
            ret.add(cur_set);
        }
        Benchmarker.done(3);
        return ret;
    }

    public boolean checkForDuplicates(List collisions, Motion one, Motion two) {
        byte c1 = one.getAircraft().getCallsign()[5];
        byte c2 = two.getAircraft().getCallsign()[5];
        Iterator iter = collisions.iterator();
        while (iter.hasNext()) {
            Collision c = (Collision)iter.next();
            if (c.first().getCallsign()[5] != c1 || c.second().getCallsign()[5] != c2) continue;
            return false;
        }
        return true;
    }

    public int determineCollisions(List motions, List ret) {
        Benchmarker.set(5);
        int _ret = 0;
        Motion[] _motions = (Motion[])motions.toArray(new Motion[motions.size()]);
        int i = 0;
        while (i < _motions.length - 1) {
            Motion one = _motions[i];
            int j = i + 1;
            while (j < _motions.length) {
                Motion two = _motions[j];
                minicdj.collision.Vector3d vec = one.findIntersection(two);
                if (vec != null) {
                    ret.add(new Collision(one.getAircraft(), two.getAircraft(), vec));
                    ++_ret;
                }
                ++j;
            }
            ++i;
        }
        Benchmarker.done(5);
        return _ret;
    }

    public void dumpFrame(String debugPrefix) {
        String prefix = String.valueOf(debugPrefix) + this.frameno + " ";
        int offset = 0;
        int i = 0;
        while (i < this.currentFrame.planeCnt) {
            int cslen = this.currentFrame.lengths[i];
            Console.println(String.valueOf(prefix) + new String(this.currentFrame.callsigns, offset, cslen) + " " + this.currentFrame.positions[3 * i] + " " + this.currentFrame.positions[3 * i + 1] + " " + this.currentFrame.positions[3 * i + 2] + " ");
            offset += cslen;
            ++i;
        }
    }

    public void setFrame(RawFrame f) {
        if (Constants.DEBUG_DETECTOR || Constants.DUMP_RECEIVED_FRAMES || Constants.SYNCHRONOUS_DETECTOR) {
            ++this.frameno;
        }
        this.currentFrame = f;
        if (Constants.DUMP_RECEIVED_FRAMES) {
            this.dumpFrame("CD-R-FRAME: ");
        }
    }

    public List createMotions() {
        Benchmarker.set(6);
        LinkedList ret = new LinkedList();
        HashSet poked = new HashSet();
        int i = 0;
        int pos = 0;
        while (i < this.currentFrame.planeCnt) {
            float x = this.currentFrame.positions[3 * i];
            float y = this.currentFrame.positions[3 * i + 1];
            float z = this.currentFrame.positions[3 * i + 2];
            byte[] cs = new byte[this.currentFrame.lengths[i]];
            int j = 0;
            while (j < cs.length) {
                cs[j] = this.currentFrame.callsigns[pos + j];
                ++j;
            }
            pos += cs.length;
            Aircraft craft = new Aircraft(cs);
            minicdj.collision.Vector3d new_pos = new minicdj.collision.Vector3d(x, y, z);
            poked.add(craft);
            Vector3d old_pos = this.state.get(new CallSign(craft.getCallsign()));
            if (old_pos == null) {
                this.state.put(this.mkCallsignInPersistentScope(craft.getCallsign()), new_pos.x, new_pos.y, new_pos.z);
                Motion m = new Motion(craft, new_pos);
                if (Constants.DEBUG_DETECTOR || Constants.SYNCHRONOUS_DETECTOR) {
                    Console.println("createMotions: old position is null, adding motion: " + m);
                }
                ret.add(m);
            } else {
                minicdj.collision.Vector3d save_old_position = new minicdj.collision.Vector3d(old_pos.x, old_pos.y, old_pos.z);
                old_pos.set(new_pos.x, new_pos.y, new_pos.z);
                Motion m = new Motion(craft, save_old_position, new_pos);
                if (Constants.DEBUG_DETECTOR || Constants.SYNCHRONOUS_DETECTOR) {
                    Console.println("createMotions: adding motion: " + m);
                }
                ret.add(m);
            }
            ++i;
        }
        Benchmarker.done(6);
        return ret;
    }

    CallSign mkCallsignInPersistentScope(byte[] cs) {
        int i = 0;
        while (i < cs.length) {
            this.r.cs[i] = cs[i];
            ++i;
        }
        return this.r.c;
    }

    static class R
    implements Runnable {
        CallSign c;
        byte[] cs;

        R() {
        }

        @Override
        public void run() {
            this.c = new CallSign(this.cs);
        }
    }
}

