/*
 * Decompiled with CFR 0.152.
 */
package minicdj.cdx;

import devices.Console;
import icecaptools.IcecapCompileMe;
import javax.realtime.PriorityParameters;
import javax.safetycritical.Mission;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.StorageParameters;
import minicdj.cdx.Benchmarker;
import minicdj.cdx.Constants;
import minicdj.cdx.ImmortalEntry;
import minicdj.cdx.NoiseGenerator;
import minicdj.cdx.RawFrame;
import minicdj.cdx.StateTable;
import minicdj.cdx.TransientDetectorScopeEntry;
import minicdj.cdx.unannotated.NanoClock;

public class CollisionDetectorHandler
extends PeriodicEventHandler {
    Mission mission;
    private final TransientDetectorScopeEntry cd = new TransientDetectorScopeEntry(new StateTable(), 10.0f);
    public final NoiseGenerator noiseGenerator = new NoiseGenerator();
    public boolean stop = false;

    public CollisionDetectorHandler(Mission mission) {
        super(new PriorityParameters(98), null, new StorageParameters(Constants.TRANSIENT_DETECTOR_SCOPE_SIZE, null, 0L, 0L, 0L));
        this.mission = mission;
    }

    @IcecapCompileMe
    public void runDetectorInScope(TransientDetectorScopeEntry cd) {
        Benchmarker.set(14);
        RawFrame f = ImmortalEntry.frameBuffer.getFrame();
        if (f == null) {
            ++ImmortalEntry.frameNotReadyCount;
            Console.println("Frame not ready");
            Benchmarker.done(14);
            return;
        }
        int framesProcessed = ImmortalEntry.framesProcessed;
        if (framesProcessed + ImmortalEntry.droppedFrames == Constants.MAX_FRAMES) {
            this.stop = true;
            Benchmarker.done(14);
            return;
        }
        long heapFreeBefore = Runtime.getRuntime().freeMemory();
        long timeBefore = NanoClock.now();
        this.noiseGenerator.generateNoiseIfEnabled();
        Benchmarker.set(Benchmarker.RAPITA_SETFRAME);
        cd.setFrame(f);
        Benchmarker.done(Benchmarker.RAPITA_SETFRAME);
        cd.run();
        long timeAfter = NanoClock.now();
        long heapFreeAfter = Runtime.getRuntime().freeMemory();
        if (ImmortalEntry.recordedRuns < ImmortalEntry.maxDetectorRuns) {
            ImmortalEntry.timesBefore[ImmortalEntry.recordedRuns] = timeBefore;
            ImmortalEntry.timesAfter[ImmortalEntry.recordedRuns] = timeAfter;
            ImmortalEntry.heapFreeBefore[ImmortalEntry.recordedRuns] = heapFreeBefore;
            ImmortalEntry.heapFreeAfter[ImmortalEntry.recordedRuns] = heapFreeAfter;
            ++ImmortalEntry.recordedRuns;
        }
        if (++ImmortalEntry.framesProcessed + ImmortalEntry.droppedFrames == Constants.MAX_FRAMES) {
            this.stop = true;
        }
        Benchmarker.done(14);
    }

    @Override
    public void handleAsyncEvent() {
        try {
            if (!this.stop) {
                long now;
                ImmortalEntry.detectorReleaseTimes[ImmortalEntry.recordedDetectorReleaseTimes] = now = NanoClock.now();
                ImmortalEntry.detectorReportedMiss[ImmortalEntry.recordedDetectorReleaseTimes] = false;
                ++ImmortalEntry.recordedDetectorReleaseTimes;
                this.runDetectorInScope(this.cd);
            } else {
                Console.println("Terminating");
                this.mission.getSequencer().signalTermination();
            }
        }
        catch (Throwable e) {
            Console.println("CollisionDetectorHandler:Exception thrown by runDetectorInScope: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public StorageParameters getThreadConfigurationParameters() {
        return null;
    }
}

