/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.safetycritical.Monitor;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.ScjProcess;
import javax.safetycritical.Services;
import vm.ClockInterruptHandler;
import vm.Process;
import vm.Scheduler;

final class PrioritySchedulerImpl
implements Scheduler {
    PrioritySchedulerImpl() {
    }

    @Override
    public Process getNextProcess() {
        ClockInterruptHandler.instance.disable();
        ScjProcess scjProcess = PriorityScheduler.instance().move();
        if (scjProcess != null) {
            scjProcess.switchToPrivateMemArea();
            ClockInterruptHandler.instance.enable();
            return scjProcess.process;
        }
        PriorityScheduler.instance().stop(PriorityScheduler.instance().current.process);
        ClockInterruptHandler.instance.enable();
        return null;
    }

    @Override
    public void wait(Object target) {
        ClockInterruptHandler.instance.disable();
        Monitor monitor = Monitor.getMonitor(target);
        monitor.unlock();
        PriorityScheduler.instance().current.state = 7;
        PriorityScheduler.instance().pFrame.waitQueue.addProcess(monitor, PriorityScheduler.instance().current);
        PriorityScheduler.instance().moveToNext();
        ClockInterruptHandler.instance.enable();
        ClockInterruptHandler.instance.yield();
    }

    @Override
    public void notify(Object target) {
        ClockInterruptHandler.instance.disable();
        Monitor monitor = Monitor.getMonitor(target);
        ScjProcess process = PriorityScheduler.instance().pFrame.waitQueue.getNextProcess(monitor);
        if (process != null) {
            process.state = 8;
            PriorityScheduler.instance().pFrame.lockQueue.addProcess(monitor, process);
        }
        ClockInterruptHandler.instance.enable();
    }

    @Override
    public void notifyAll(Object target) {
        ClockInterruptHandler.instance.disable();
        Monitor monitor = Monitor.getMonitor(target);
        ScjProcess process = PriorityScheduler.instance().pFrame.waitQueue.getNextProcess(monitor);
        while (process != null) {
            process.state = 8;
            PriorityScheduler.instance().pFrame.lockQueue.addProcess(monitor, process);
            process = PriorityScheduler.instance().pFrame.waitQueue.getNextProcess(monitor);
        }
        ClockInterruptHandler.instance.enable();
    }

    @Override
    public Monitor getDefaultMonitor() {
        return new Monitor(Services.getDefaultCeiling());
    }
}

