/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.AbsoluteTime;
import javax.realtime.AperiodicParameters;
import javax.realtime.Clock;
import javax.realtime.HighResolutionTime;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.safetycritical.Launcher;
import javax.safetycritical.ManagedEventHandler;
import javax.safetycritical.OSProcess;
import javax.safetycritical.Services;
import javax.safetycritical.StorageParameters;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.Phase;
import javax.safetycritical.annotate.SCJAllowed;
import javax.safetycritical.annotate.SCJRestricted;

@SCJAllowed(value=Level.LEVEL_1)
public abstract class OneShotEventHandler
extends ManagedEventHandler {
    HighResolutionTime releaseTime;
    boolean deschedulePending = false;
    int state = 0;

    @SCJAllowed(value=Level.LEVEL_1)
    @SCJRestricted(value=Phase.INITIALIZE)
    public OneShotEventHandler(PriorityParameters priority, HighResolutionTime releaseTime, AperiodicParameters release, StorageParameters storage) {
        this(priority, releaseTime, release, storage, null);
    }

    OneShotEventHandler(PriorityParameters priority, HighResolutionTime releaseTime, AperiodicParameters release, StorageParameters storage, String name) {
        super(priority, release, storage, name);
        if (releaseTime == null) {
            this.releaseTime = new RelativeTime(Clock.getRealtimeClock());
        } else {
            if (releaseTime instanceof AbsoluteTime) {
                throw new IllegalArgumentException("releaseTime of type AbsoluteTime not implemented");
            }
            this.releaseTime = releaseTime;
        }
        if (Launcher.useOS) {
            Services.setCeiling(this, this.priority.getPriority());
        }
    }

    @SCJAllowed(value=Level.LEVEL_1)
    public boolean deschedule() {
        return ManagedEventHandler.handlerBehavior.oneshotHandlerDeschedule(this);
    }

    @Override
    public final void cleanUp() {
        super.cleanUp();
    }

    @Override
    @SCJAllowed(value=Level.INFRASTRUCTURE)
    @SCJRestricted(value=Phase.INITIALIZE)
    public final void register() {
        super.register();
    }

    long getStart() {
        return (long)this.releaseTime.getNanoseconds() + this.releaseTime.getMilliseconds() * 1000000L;
    }

    public void scheduleNextReleaseTime(HighResolutionTime time) {
        ManagedEventHandler.handlerBehavior.oneshotHandlerScheduleNextReleaseTime(this, time);
    }

    synchronized void waitForNextRelease() {
        try {
            if (!this.mission.terminationPending()) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.mission.terminationPending()) {
            this.mission.currMissSeq.seqNotify();
            OSProcess.requestTermination_c(this.process.executable);
        }
    }

    synchronized void fireNextRelease() {
        this.notify();
    }

    int getTimerfd() {
        return this.process.executable.startTimer_c;
    }
}

