/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import devices.Console;
import icecaptools.IcecapCompileMe;
import javax.safetycritical.ManagedSchedMethods;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.ScjProcess;
import vm.ClockInterruptHandler;
import vm.InterruptHandler;

final class Monitor
extends vm.Monitor {
    int ceiling;
    private int synchCounter;
    private int priority;
    private ManagedSchedulable owner;
    private InterruptHandler clock;

    Monitor(int ceiling) {
        this.ceiling = ceiling;
        this.clock = ClockInterruptHandler.instance;
    }

    @Override
    public void lock() {
        this.clock.disable();
        ScjProcess currentProcess = PriorityScheduler.instance().getCurrentProcess();
        if (currentProcess != null) {
            ManagedSchedulable msObj = currentProcess.getTarget();
            if (this.owner == null) {
                this.setOwner(msObj);
            }
            if (this.owner == msObj) {
                ++this.synchCounter;
                if (this.synchCounter == 1) {
                    this.priority = ManagedSchedMethods.getPriorityParameter(msObj).getPriority();
                    ManagedSchedMethods.getPriorityParameter(msObj).setPriority(Monitor.max(this.priority, this.ceiling) + 1);
                }
                this.clock.enable();
            } else {
                currentProcess.state = 8;
                PriorityScheduler.instance().addProcessToLockQueue(this, currentProcess);
                this.clock.enable();
                ClockInterruptHandler.instance.yield();
            }
        } else {
            this.clock.enable();
        }
    }

    @Override
    @IcecapCompileMe
    public void unlock() {
        this.clock.disable();
        ScjProcess currentProcess = PriorityScheduler.instance().getCurrentProcess();
        if (currentProcess != null) {
            ManagedSchedulable msObj = currentProcess.getTarget();
            if (this.owner == msObj) {
                --this.synchCounter;
                if (this.synchCounter == 0) {
                    ManagedSchedMethods.getPriorityParameter(msObj).setPriority(this.priority);
                    ScjProcess process = PriorityScheduler.instance().getProcessFromLockQueue(this);
                    if (process != null) {
                        this.setOwner(process.getTarget());
                        ++this.synchCounter;
                        this.priority = ManagedSchedMethods.getPriorityParameter(msObj).getPriority();
                        ManagedSchedMethods.getPriorityParameter(msObj).setPriority(Monitor.max(this.priority, this.ceiling) + 1);
                        process.state = 1;
                        PriorityScheduler.instance().insertReadyQueue(process);
                    } else {
                        this.setOwner(null);
                    }
                }
            } else {
                Console.println("    Monitor.unlock: UPS, - not owner");
                this.clock.enable();
                throw new IllegalMonitorStateException("Not owner on exit");
            }
            this.clock.enable();
        } else {
            this.clock.enable();
        }
    }

    private void setOwner(ManagedSchedulable msObj) {
        this.owner = msObj;
    }

    private static int max(int x, int y) {
        if (x > y) {
            return x;
        }
        return y;
    }

    static Monitor getMonitor(Object target) {
        Object obj = Monitor.getAttachedMonitor(target);
        if (obj == null || !(obj instanceof Monitor)) {
            throw new IllegalMonitorStateException("the target is not a lock:" + obj.toString());
        }
        return (Monitor)obj;
    }
}

