/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.AbsoluteTime;
import javax.realtime.HighResolutionTime;
import javax.realtime.MemoryArea;
import javax.realtime.PriorityParameters;
import javax.realtime.RealtimeThread;
import javax.realtime.RelativeTime;
import javax.safetycritical.AffinitySet;
import javax.safetycritical.ManagedMemory;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.ManagedSchedulableSet;
import javax.safetycritical.Mission;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.PrivateMemory;
import javax.safetycritical.Process;
import javax.safetycritical.ScjProcess;
import javax.safetycritical.StorageParameters;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.Phase;
import javax.safetycritical.annotate.SCJAllowed;
import javax.safetycritical.annotate.SCJRestricted;
import vm.ClockInterruptHandler;
import vm.Memory;

@SCJAllowed(value=Level.LEVEL_2)
public class ManagedThread
extends RealtimeThread
implements ManagedSchedulable {
    PriorityParameters priority;
    StorageParameters storage;
    Process process = null;
    Mission mission = null;
    ManagedMemory privateMemory;
    ManagedMemory currentMemory;
    String name;
    AffinitySet set = null;
    boolean isRegistered;
    boolean isInMissionScope;

    public ManagedThread(PriorityParameters priority, StorageParameters storage) {
        this(priority, storage, null);
    }

    public ManagedThread(PriorityParameters priority, StorageParameters storage, Runnable logic) {
        this(priority, storage, logic, null);
    }

    ManagedThread(PriorityParameters priority, StorageParameters storage, Runnable logic, String name) {
        super(priority, logic);
        this.priority = priority;
        if (storage == null) {
            throw new IllegalArgumentException("storage is null");
        }
        this.storage = storage;
        this.name = name;
        this.mission = Mission.getMission();
        if (this.mission == null) {
            throw new IllegalArgumentException("mission is null");
        }
        int backingStoreOfThisMemory = this.mission == null ? MemoryArea.getRemainingMemorySize() : (int)this.storage.totalBackingStore;
        MemoryArea backingStoreProvider = this.mission == null ? MemoryArea.overAllBackingStore : this.mission.currMissSeq.missionMemory;
        String privateMemoryName = Memory.getNextMemoryName("PvtMem");
        this.privateMemory = new PrivateMemory((int)storage.getMaximalMemoryArea(), backingStoreOfThisMemory, backingStoreProvider, privateMemoryName);
        this.currentMemory = this.mission.currMissSeq.missionMemory;
        this.set = this.mission.currMissSeq.set;
        this.isRegistered = false;
        this.isInMissionScope = false;
    }

    Mission getMission() {
        return this.mission;
    }

    @Override
    @SCJAllowed(value=Level.INFRASTRUCTURE)
    @SCJRestricted(value=Phase.INITIALIZE)
    public final void register() {
        ManagedSchedulableSet msSet = this.mission.msSetForMission;
        msSet.addMS(this);
        this.isRegistered = true;
        this.isInMissionScope = true;
    }

    @Override
    @SCJAllowed(value=Level.SUPPORT)
    @SCJRestricted(value=Phase.CLEANUP)
    public void cleanUp() {
        this.privateMemory.removeArea();
    }

    @Override
    public void signalTermination() {
    }

    public static void sleep(HighResolutionTime time) throws InterruptedException {
        ClockInterruptHandler.instance.disable();
        ScjProcess current = PriorityScheduler.instance().current;
        if (time instanceof RelativeTime) {
            current.next.add((RelativeTime)time, current.next);
        } else if (time instanceof AbsoluteTime) {
            current.next = new AbsoluteTime((AbsoluteTime)time);
        } else {
            throw new UnsupportedOperationException();
        }
        current.state = 4;
        ClockInterruptHandler.instance.enable();
        ClockInterruptHandler.instance.yield();
    }

    PriorityParameters getPriorityParam() {
        return this.priority;
    }

    void setName(String name) {
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    void setCurrentMemory(ManagedMemory current) {
        this.currentMemory = current;
    }

    ManagedMemory getCurrentMemory() {
        return this.currentMemory;
    }

    AffinitySet getAffinitySet() {
        return this.set;
    }

    ManagedMemory getMemory() {
        return this.privateMemory;
    }
}

