/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import devices.Console;
import javax.realtime.AbsoluteTime;
import javax.realtime.BoundAsyncEventHandler;
import javax.realtime.HighResolutionTime;
import javax.realtime.MemoryArea;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.realtime.ReleaseParameters;
import javax.safetycritical.AffinitySet;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.Launcher;
import javax.safetycritical.ManagedMemory;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.ManagedSchedulableSet;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.Monitor;
import javax.safetycritical.OSProcess;
import javax.safetycritical.OneShotEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.PrivateMemory;
import javax.safetycritical.Process;
import javax.safetycritical.StorageParameters;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.Phase;
import javax.safetycritical.annotate.SCJAllowed;
import javax.safetycritical.annotate.SCJRestricted;
import vm.ClockInterruptHandler;
import vm.Memory;
import vm.RealtimeClock;

@SCJAllowed
public abstract class ManagedEventHandler
extends BoundAsyncEventHandler
implements ManagedSchedulable {
    PriorityParameters priority;
    StorageParameters storage;
    Process process = null;
    Mission mission = null;
    ManagedMemory privateMemory;
    ManagedMemory currentMemory;
    ReleaseParameters release;
    String name;
    AffinitySet set = null;
    boolean isRegistered;
    boolean isInMissionScope;
    static HandlerBehavior handlerBehavior = null;

    public ManagedEventHandler(PriorityParameters priority, ReleaseParameters release, StorageParameters storage) {
        this(priority, release, storage, null);
    }

    ManagedEventHandler(PriorityParameters priority, ReleaseParameters release, StorageParameters storage, String name) {
        int backingStoreOfThisMemory;
        if (priority == null) {
            throw new IllegalArgumentException("priority is null");
        }
        if (release == null) {
            throw new IllegalArgumentException("release is null");
        }
        if (storage == null) {
            throw new IllegalArgumentException("storage is null");
        }
        this.priority = priority;
        this.release = release;
        this.storage = storage;
        this.name = name;
        this.mission = Mission.getMission();
        if (this.mission == null && this instanceof MissionSequencer) {
            backingStoreOfThisMemory = MemoryArea.getRemainingMemorySize();
            this.currentMemory = ManagedMemory.ImmortalMemory.instance();
        } else {
            backingStoreOfThisMemory = (int)this.storage.totalBackingStore;
            if (this.mission != null) {
                this.currentMemory = this.mission.currMissSeq.missionMemory;
                this.set = this.mission.currMissSeq.set;
            }
        }
        MemoryArea backingStoreProvider = this.mission == null ? MemoryArea.overAllBackingStore : this.mission.currMissSeq.missionMemory;
        String privateMemoryName = Memory.getNextMemoryName("PvtMem");
        this.privateMemory = new PrivateMemory((int)this.storage.getMaximalMemoryArea(), backingStoreOfThisMemory, backingStoreProvider, privateMemoryName);
        this.isRegistered = false;
        this.isInMissionScope = false;
    }

    @Override
    public abstract void handleAsyncEvent();

    @Override
    @SCJAllowed(value=Level.SUPPORT)
    @SCJRestricted(value=Phase.CLEANUP)
    public void cleanUp() {
        this.privateMemory.removeArea();
    }

    @Override
    @SCJAllowed(value=Level.INFRASTRUCTURE)
    @SCJRestricted(value=Phase.INITIALIZE)
    public void register() {
        ManagedSchedulableSet hs = this.mission.msSetForMission;
        hs.addMS(this);
        this.isRegistered = true;
        this.isInMissionScope = true;
    }

    @Override
    @SCJAllowed(value=Level.SUPPORT)
    public void signalTermination() {
    }

    @SCJAllowed(value=Level.LEVEL_1)
    public AbsoluteTime getLastReleaseTime() {
        return null;
    }

    Mission getMission() {
        return this.mission;
    }

    void setName(String name) {
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    PriorityParameters getPriorityParam() {
        return this.priority;
    }

    ReleaseParameters getReleaseParam() {
        return this.release;
    }

    void setCurrentMemory(ManagedMemory current) {
        this.currentMemory = current;
    }

    ManagedMemory getCurrentMemory() {
        return this.currentMemory;
    }

    AffinitySet getAffinitySet() {
        return this.set;
    }

    ManagedMemory getMemory() {
        return this.privateMemory;
    }

    static abstract class HandlerBehavior {
        HandlerBehavior() {
        }

        abstract void aperiodicHandlerRelease(AperiodicEventHandler var1);

        abstract boolean oneshotHandlerDeschedule(OneShotEventHandler var1);

        abstract void oneshotHandlerScheduleNextReleaseTime(OneShotEventHandler var1, HighResolutionTime var2);

        abstract void initMissionSequencer(MissionSequencer<?> var1);

        abstract void cleanOuterMissionSequencer(MissionSequencer<?> var1);

        abstract void missionSequencerSingleTermination(MissionSequencer<?> var1);

        abstract void missionSequencerExecutePhase(MissionSequencer<?> var1);
    }

    static final class MulticoreBehavior
    extends HandlerBehavior {
        MulticoreBehavior() {
        }

        @Override
        void aperiodicHandlerRelease(AperiodicEventHandler handler) {
            handler.fireNextRelease();
            handler.isReleased = true;
        }

        @Override
        boolean oneshotHandlerDeschedule(OneShotEventHandler handler) {
            if (handler.process.executable.startTimer_c > 0 || handler.state == 0) {
                handler.deschedulePending = true;
                OSProcess.setTimerfd(handler.process.executable.startTimer_c, 0L);
                return false;
            }
            return true;
        }

        @Override
        void oneshotHandlerScheduleNextReleaseTime(OneShotEventHandler handler, HighResolutionTime time) {
            if (time == null) {
                handler.deschedule();
            } else {
                if (time instanceof AbsoluteTime) {
                    handler.releaseTime = new RelativeTime(0L, 0);
                } else if (time instanceof RelativeTime) {
                    if (handler.releaseTime.getMilliseconds() < 0L || handler.releaseTime.getMilliseconds() == 0L && handler.releaseTime.getNanoseconds() < 0) {
                        throw new IllegalArgumentException("release time < 0");
                    }
                    handler.releaseTime = time;
                } else {
                    throw new IllegalArgumentException("wrong time form");
                }
                if (handler.state == 0) {
                    OSProcess.setTimerfd(handler.process.executable.startTimer_c, handler.getStart());
                }
                if (handler.state == 2) {
                    OSProcess.setTimerfd(handler.process.executable.startTimer_c, handler.getStart());
                    handler.fireNextRelease();
                }
            }
        }

        @Override
        void initMissionSequencer(MissionSequencer<?> handler) {
            if (MissionSequencer.isOuterMostSeq) {
                MissionSequencer.outerMostSeq = handler;
                MissionSequencer.isOuterMostSeq = false;
                OSProcess.setOuterMostMissionSequencer(handler.priority.getPriority());
                handler.set = Launcher.level == 1 ? this.findAffinitySetForLevel1() : AffinitySet.AFFINITY_SET[0];
            }
        }

        private AffinitySet findAffinitySetForLevel1() {
            int processor = OSProcess.getCurrentCPUID();
            int i = 0;
            while (i < AffinitySet.AFFINITY_SET.length) {
                if (AffinitySet.AFFINITY_SET[i].processorSet[0] == processor) {
                    return AffinitySet.AFFINITY_SET[i];
                }
                ++i;
            }
            throw new NullPointerException();
        }

        @Override
        void cleanOuterMissionSequencer(MissionSequencer<?> handler) {
        }

        @Override
        void missionSequencerSingleTermination(MissionSequencer<?> handler) {
            handler.terminateSeq = true;
            ((Mission)handler.currMission).requestTermination();
        }

        @Override
        void missionSequencerExecutePhase(MissionSequencer<?> handler) {
            handler.missionMemory.enterToExecute((Mission)handler.currMission);
        }
    }

    static final class SinglecoreBehavior
    extends HandlerBehavior {
        SinglecoreBehavior() {
        }

        @Override
        void aperiodicHandlerRelease(AperiodicEventHandler handler) {
            PriorityScheduler.instance().release(handler);
        }

        @Override
        boolean oneshotHandlerDeschedule(OneShotEventHandler handler) {
            ManagedSchedulableSet hs = Mission.getMission().msSetForMission;
            if (hs.contains(handler)) {
                hs.removeMSObject(handler);
                return true;
            }
            return false;
        }

        @Override
        void oneshotHandlerScheduleNextReleaseTime(OneShotEventHandler handler, HighResolutionTime time) {
        }

        @Override
        void initMissionSequencer(MissionSequencer<?> handler) {
            if (MissionSequencer.isOuterMostSeq) {
                MissionSequencer.outerMostSeq = handler;
                if (Launcher.level != 0) {
                    PriorityScheduler.instance().addOuterMostSeq(handler);
                }
            } else {
                if (Launcher.level < 2) {
                    throw new IllegalStateException("MissSeq not outer-most");
                }
                handler.outerSeq = Mission.getMission().currMissSeq;
            }
            MissionSequencer.isOuterMostSeq = false;
            handler.lock = Monitor.getMonitor(handler);
        }

        @Override
        void cleanOuterMissionSequencer(MissionSequencer<?> handler) {
            if (Launcher.level == 2) {
                Console.println("MS.T: " + handler.name + "; #Missions: " + MissionSequencer.howManyMissions + "; outerSeq: " + handler.outerSeq);
                ClockInterruptHandler.instance.disable();
                if (handler.outerSeq != null) {
                    ((Mission)handler.outerSeq.currMission).msSetForMission.removeMSObject(handler);
                }
                ClockInterruptHandler.instance.enable();
            }
        }

        @Override
        void missionSequencerSingleTermination(MissionSequencer<?> handler) {
            ClockInterruptHandler.instance.disable();
            Console.println("------ MS.signalTermination: " + handler.name);
            handler.terminateSeq = true;
            ((Mission)handler.currMission).requestTermination();
            ClockInterruptHandler.instance.enable();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        void missionSequencerExecutePhase(MissionSequencer<?> handler) {
            block1: {
                handler.missionMemory.enterToExecute((Mission)handler.currMission);
                if (Launcher.level <= 0) ** GOTO lbl6
                handler.seqWait();
                break block1;
lbl-1000:
                // 1 sources

                {
                    RealtimeClock.awaitNextTick();
lbl6:
                    // 2 sources

                    ** while (!handler.currMission.terminationPending() && handler.currMission.msSetForMission.msCount > 0)
                }
            }
        }
    }
}

