/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.MemoryArea;
import javax.safetycritical.AffinitySet;
import javax.safetycritical.CyclicScheduler;
import javax.safetycritical.ManagedMemory;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.MultiprocessorHelpingScheduler;
import javax.safetycritical.OSProcess;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.PrivateMemory;
import javax.safetycritical.Safelet;
import javax.safetycritical.ScjProcess;
import javax.scj.util.Configuration;
import javax.scj.util.Const;
import vm.Machine;
import vm.Memory;

abstract class Launcher
implements Runnable {
    Safelet<?> app;
    static int level;
    static boolean useOS;

    static {
        useOS = false;
    }

    Launcher(Safelet<?> app, int level) {
        this(app, level, false);
    }

    Launcher(Safelet<?> app, int level, boolean useOS) {
        if (level < 0 || level > 2 || app == null) {
            throw new IllegalArgumentException();
        }
        this.app = app;
        Launcher.level = level;
        Launcher.useOS = useOS;
    }

    @Override
    public void run() {
        this.app.initializeApplication();
        this.start();
    }

    void createImmortalMemory() {
        ManagedMemory.allocateBackingStore(Const.OVERALL_BACKING_STORE);
        if (Memory.memoryAreaTrackingEnabled) {
            new PrivateMemory(Const.MEMORY_TRACKER_AREA_SIZE, Const.MEMORY_TRACKER_AREA_SIZE, MemoryArea.overAllBackingStore, "MemTrk");
        }
        ManagedMemory.ImmortalMemory immortalMem = new ManagedMemory.ImmortalMemory(2 * Const.IMMORTAL_MEM);
        immortalMem.executeInArea(this);
    }

    abstract void start();

    void startLevel0() {
        MissionSequencer<?> seq = this.app.getSequencer();
        CyclicScheduler.instance().start(seq);
    }

    void startLevel1_2() {
        PriorityScheduler sch = PriorityScheduler.instance();
        sch.insertReadyQueue(ScjProcess.createIdleProcess());
        this.app.getSequencer();
        PriorityScheduler.instance().start();
    }

    void startwithOS() {
        this.initAffinfitySetsMulticore();
        Machine.setCurrentScheduler(new MultiprocessorHelpingScheduler());
        OSProcess.initSpecificID();
        MissionSequencer<?> outerMostMS = this.app.getSequencer();
        outerMostMS.privateMemory.enter(outerMostMS);
        outerMostMS.cleanUp();
    }

    private void initAffinfitySetsMulticore() {
        if (Configuration.processors != null) {
            AffinitySet.checkAndInitAffinityByCustomized(Configuration.processors);
        } else {
            switch (level) {
                case 0: {
                    AffinitySet.initAffinitySet_Level0();
                    break;
                }
                case 1: {
                    AffinitySet.initAffinitySet_Level1();
                    break;
                }
                case 2: {
                    AffinitySet.initAffinitySet_Level2();
                }
            }
        }
    }
}

