/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.RelativeTime;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed
public final class Frame {
    RelativeTime duration;
    PeriodicEventHandler[] handlers;

    @SCJAllowed
    public Frame(RelativeTime duration, PeriodicEventHandler[] handlers) {
        if (duration == null) {
            throw new IllegalArgumentException();
        }
        if (duration != null && duration.getMilliseconds() * 1000000L + (long)duration.getNanoseconds() <= 0L) {
            throw new IllegalArgumentException();
        }
        if (handlers == null) {
            throw new IllegalArgumentException();
        }
        this.duration = duration;
        this.handlers = handlers;
    }

    PeriodicEventHandler[] getHandlers() {
        return this.handlers;
    }

    RelativeTime getDuration() {
        return this.duration;
    }
}

