/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import devices.Console;
import javax.safetycritical.Launcher;
import javax.safetycritical.ManagedEventHandler;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.ManagedThread;
import javax.safetycritical.OSProcess;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed
public final class AffinitySet {
    static AffinitySet[] AFFINITY_SET;
    int[] processorSet;

    AffinitySet(int processorNumber) {
        this.processorSet = new int[1];
        this.processorSet[0] = processorNumber;
    }

    AffinitySet(int[] processors) {
        this.processorSet = processors;
    }

    public static AffinitySet generate(int processorNumber) {
        if (Launcher.level != 2) {
            throw new IllegalArgumentException();
        }
        boolean isProcessorInSet = false;
        int i = 0;
        while (i < AffinitySet.AFFINITY_SET[0].processorSet.length) {
            if (AffinitySet.AFFINITY_SET[0].processorSet[i] == processorNumber) {
                isProcessorInSet = true;
            }
            ++i;
        }
        if (isProcessorInSet) {
            return new AffinitySet(processorNumber);
        }
        throw new IllegalArgumentException();
    }

    public static final AffinitySet getAffinitySet(ManagedSchedulable sched) {
        AffinitySet set = null;
        set = sched instanceof ManagedEventHandler ? ((ManagedEventHandler)sched).set : ((ManagedThread)sched).set;
        return set;
    }

    public static final void setProcessorAffinity(AffinitySet set, ManagedSchedulable sched) {
        if (Launcher.level < 1) {
            throw new IllegalArgumentException();
        }
        if (sched instanceof ManagedEventHandler) {
            ManagedEventHandler handler = (ManagedEventHandler)sched;
            handler.set = set;
        } else {
            ManagedThread thread = (ManagedThread)sched;
            thread.set = set;
        }
    }

    public final boolean isProcessorInSet(int processorNumber) {
        int i = 0;
        while (i < this.processorSet.length) {
            if (this.processorSet[i] == processorNumber) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static void initAffinitySet_Level0() {
        OSProcess.setOMMSAffinitySet(0);
        AFFINITY_SET = new AffinitySet[1];
        AffinitySet.AFFINITY_SET[0] = new AffinitySet(OSProcess.getCurrentCPUID());
    }

    protected static void initAffinitySet_Level1() {
        AFFINITY_SET = new AffinitySet[OSProcess.getAvailableCPUCount()];
        int count = 0;
        int processorNumber = OSProcess.getAllCPUCount();
        int i = 0;
        while (i < processorNumber) {
            if (OSProcess.isProcessorInSet(i) != 0) {
                AffinitySet.AFFINITY_SET[count] = new AffinitySet(i);
                ++count;
            }
            ++i;
        }
        OSProcess.setOMMSAffinitySet(1);
    }

    protected static void initAffinitySet_Level2() {
        OSProcess.setOMMSAffinitySet(2);
        AFFINITY_SET = new AffinitySet[OSProcess.getAvailableCPUCount() + 1];
        int[] processors = new int[OSProcess.getAvailableCPUCount()];
        int count = 0;
        int processorNumber = OSProcess.getAllCPUCount();
        int i = 0;
        while (i < processorNumber) {
            if (OSProcess.isProcessorInSet(i) != 0) {
                processors[count] = i;
                ++count;
            }
            ++i;
        }
        AffinitySet.AFFINITY_SET[0] = new AffinitySet(processors);
    }

    protected static void checkAndInitAffinityByCustomized(int[][] processor) {
        switch (Launcher.level) {
            case 0: {
                if (processor.length == 1 && processor[0].length == 1 && OSProcess.isProcessorInSet(processor[0][0]) != 0) {
                    AFFINITY_SET = new AffinitySet[1];
                    AffinitySet.AFFINITY_SET[0] = new AffinitySet(processor[0]);
                    OSProcess.setAffinity(processor[0].length, processor[0]);
                    break;
                }
                Console.println("Notice: Level0 can only has one affinity set with one valid processor");
                throw new IllegalArgumentException();
            }
            case 1: {
                if (processor.length > 0 && processor.length <= OSProcess.getAvailableCPUCount()) {
                    int i = 0;
                    while (i < processor.length) {
                        if (processor[i].length != 1 || OSProcess.isProcessorInSet(processor[i][0]) == 0) {
                            Console.println("invaild processor id found");
                            throw new IllegalArgumentException();
                        }
                        ++i;
                    }
                    AFFINITY_SET = new AffinitySet[processor.length];
                    i = 0;
                    while (i < AFFINITY_SET.length) {
                        AffinitySet.AFFINITY_SET[i] = new AffinitySet(processor[i]);
                        ++i;
                    }
                    OSProcess.setAffinity(AffinitySet.AFFINITY_SET[0].processorSet.length, AffinitySet.AFFINITY_SET[0].processorSet);
                    break;
                }
                Console.println("Notice: In Level1 the number of affinity sets should be greater than 0 but not greater than the number of available processors.");
                throw new IllegalArgumentException();
            }
            case 2: {
                if (processor.length <= 0) {
                    Console.println("Notice: In level2 the number of affinity sets should be greater than 0");
                    throw new IllegalArgumentException();
                }
                int i = 0;
                while (i < processor.length) {
                    if (processor[i].length <= 0 || processor[i].length > OSProcess.getAvailableCPUCount()) {
                        Console.println("Notice: In level2 the number of processors in a affinity set should greater than 0 but not greater than the number of available processors");
                        throw new IllegalArgumentException();
                    }
                    int j = 0;
                    while (j < processor[i].length) {
                        if (OSProcess.isProcessorInSet(processor[i][j]) == 0) {
                            Console.println("invaild processor id found");
                            throw new IllegalArgumentException();
                        }
                        ++j;
                    }
                    ++i;
                }
                AFFINITY_SET = new AffinitySet[processor.length];
                i = 0;
                while (i < AFFINITY_SET.length) {
                    AffinitySet.AFFINITY_SET[i] = new AffinitySet(processor[i]);
                    ++i;
                }
                OSProcess.setAffinity(AffinitySet.AFFINITY_SET[0].processorSet.length, AffinitySet.AFFINITY_SET[0].processorSet);
            }
        }
    }

    public static void printAffinitySets() {
        Console.println("-----------Affinity Sets---------");
        int i = 0;
        while (i < AFFINITY_SET.length) {
            if (AFFINITY_SET[i] != null) {
                int j = 0;
                while (j < AffinitySet.AFFINITY_SET[i].processorSet.length) {
                    Console.print(String.valueOf(AffinitySet.AFFINITY_SET[i].processorSet[j]) + "\t");
                    ++j;
                }
                Console.print("\n");
            }
            ++i;
        }
        Console.println("----------------------------------");
    }

    public void formatPrint(String s) {
        Console.println(String.valueOf(s) + "*********");
        Console.print(s);
        int j = 0;
        while (j < this.processorSet.length) {
            Console.print(String.valueOf(this.processorSet[j]) + "\t");
            ++j;
        }
        Console.print("\n");
        Console.println(String.valueOf(s) + "*********");
    }

    public int[] getProcessorSet() {
        return this.processorSet;
    }
}

