/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AsyncEventHandler;
import javax.realtime.RelativeTime;
import javax.realtime.ReleaseParameters;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed
public class PeriodicParameters
extends ReleaseParameters {
    RelativeTime start;
    RelativeTime period;

    public PeriodicParameters(RelativeTime start, RelativeTime period) {
        this(start, period, null, null);
    }

    @SCJAllowed(value=Level.LEVEL_1)
    public PeriodicParameters(RelativeTime start, RelativeTime period, RelativeTime deadline, AsyncEventHandler missHandler) {
        super(deadline == null ? period : deadline, missHandler);
        this.start = start == null ? new RelativeTime() : new RelativeTime(start);
        if (period == null || period.millis < 0L || period.millis == 0L && period.nanos == 0 || start.clock != period.clock) {
            throw new IllegalArgumentException("period is null or not vaild");
        }
        if (deadline != null && (deadline.millis < 0L || deadline.millis == 0L && deadline.nanos == 0 || period.clock != deadline.clock)) {
            throw new IllegalArgumentException("deadline is null or not vaild");
        }
        this.period = new RelativeTime(period);
    }

    public RelativeTime getPeriod() {
        return this.period;
    }

    public RelativeTime getStart() {
        return this.start;
    }

    RelativeTime period() {
        return this.period;
    }

    RelativeTime start() {
        return this.start;
    }
}

