/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import devices.Console;
import icecaptools.IcecapCompileMe;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;
import reflect.ObjectInfo;
import vm.Memory;

@SCJAllowed(value=Level.INFRASTRUCTURE)
public abstract class MemoryArea {
    public static MemoryArea overAllBackingStore;
    protected MemoryArea backingStoreProvider;
    private MemoryArea headOfContainedMemories;
    private MemoryArea nextContainedMemory;
    protected Memory delegate;
    private int reservedEnd;
    private int maxUsage;

    protected MemoryArea() {
    }

    protected MemoryArea(Memory delegate) {
        this.delegate = delegate;
        this.reservedEnd = delegate.getBase() + delegate.getSize();
        delegate.resize(0);
    }

    @IcecapCompileMe
    protected MemoryArea(int initialSize, int reservedSize, MemoryArea backingStoreProvider, String label) {
        int base = backingStoreProvider.reservedEnd - backingStoreProvider.getRemainingBackingstoreSize();
        int endOfAvailableSpace = backingStoreProvider.reservedEnd;
        if (base + reservedSize > endOfAvailableSpace) {
            throw new OutOfMemoryError("thrown from MemoryArea :: constructor : Out of backingstore exception: size: " + initialSize + " backingStoreSize: " + reservedSize + " base: " + base + " backingStoreEnd: " + endOfAvailableSpace);
        }
        this.backingStoreProvider = backingStoreProvider;
        this.delegate = new Memory(base, initialSize, label);
        this.reservedEnd = base + reservedSize;
        backingStoreProvider.addContainedMemory(this);
    }

    private void addContainedMemory(MemoryArea memoryArea) {
        memoryArea.nextContainedMemory = this.headOfContainedMemories;
        this.headOfContainedMemories = memoryArea;
        if (memoryArea.reservedEnd > this.maxUsage) {
            this.maxUsage = memoryArea.reservedEnd;
        }
    }

    private void removeContainedMemory(MemoryArea memoryArea) {
        if (this.headOfContainedMemories == memoryArea) {
            this.headOfContainedMemories = this.headOfContainedMemories.nextContainedMemory;
        } else {
            MemoryArea current = this.headOfContainedMemories;
            while (current.nextContainedMemory != null) {
                if (current.nextContainedMemory == memoryArea) {
                    current.nextContainedMemory = current.nextContainedMemory.nextContainedMemory;
                    return;
                }
                current = current.nextContainedMemory;
            }
        }
    }

    protected void removeMemArea() {
        if (this != overAllBackingStore) {
            this.backingStoreProvider.removeContainedMemory(this);
        }
    }

    @SCJAllowed
    public long memoryConsumed() {
        return this.delegate.consumedMemory();
    }

    @SCJAllowed
    public long memoryRemaining() {
        return this.size() - this.memoryConsumed();
    }

    @SCJAllowed
    public long size() {
        return this.delegate.getSize();
    }

    protected void resizeMemArea(long newSize) {
        if (this.memoryConsumed() < newSize && (long)this.delegate.getBase() + newSize < (long)this.reservedEnd && this.headOfContainedMemories == null) {
            this.delegate.resize((int)newSize);
            return;
        }
        throw new OutOfMemoryError("thrown from MemoryArea :: resizeMem : Out of backingstore exception ");
    }

    public static int getRemainingMemorySize() {
        return overAllBackingStore.getRemainingBackingstoreSize();
    }

    public int getRemainingBackingstoreSize() {
        int maxEnd = this.delegate.getBase() + this.delegate.getSize();
        MemoryArea current = this.headOfContainedMemories;
        while (current != null) {
            maxEnd = maxEnd > current.reservedEnd ? maxEnd : current.reservedEnd;
            current = current.nextContainedMemory;
        }
        return this.reservedEnd - maxEnd;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static void printMemoryAreas() {
        MemoryArea.print(overAllBackingStore, 0);
    }

    protected static MemoryArea getNamedMemoryArea(String name) {
        return MemoryArea.getNamedMemoryArea(overAllBackingStore, name);
    }

    private static MemoryArea getNamedMemoryArea(MemoryArea provider, String name) {
        if (provider.delegate.getName().equals(name)) {
            return provider;
        }
        MemoryArea current = provider.headOfContainedMemories;
        while (current != null) {
            MemoryArea result = MemoryArea.getNamedMemoryArea(current, name);
            if (result != null) {
                return result;
            }
            current = current.nextContainedMemory;
        }
        return null;
    }

    @SCJAllowed
    public static MemoryArea getMemoryArea(Object object) {
        int ref = ObjectInfo.getAddress(object);
        return MemoryArea.getMemoryArea(overAllBackingStore, ref);
    }

    private static MemoryArea getMemoryArea(MemoryArea provider, int ref) {
        if (provider.delegate.getBase() <= ref && ref < provider.delegate.getBase() + provider.delegate.getSize()) {
            return provider;
        }
        MemoryArea current = provider.headOfContainedMemories;
        while (current != null) {
            MemoryArea result = MemoryArea.getMemoryArea(current, ref);
            if (result != null) {
                return result;
            }
            current = current.nextContainedMemory;
        }
        return null;
    }

    protected static MemoryArea getCurrentMemoryArea() {
        Memory mem = Memory.getCurrentMemoryArea();
        return MemoryArea.getCurrentMemoryArea(overAllBackingStore, mem);
    }

    static MemoryArea getCurrentMemoryArea(MemoryArea provider, Memory mem) {
        if (provider.delegate == mem) {
            return provider;
        }
        MemoryArea current = provider.headOfContainedMemories;
        while (current != null) {
            MemoryArea result = MemoryArea.getCurrentMemoryArea(current, mem);
            if (result != null) {
                return result;
            }
            current = current.nextContainedMemory;
        }
        return null;
    }

    private static void print(MemoryArea backingStoreProvider, int indent) {
        MemoryArea current = backingStoreProvider.headOfContainedMemories;
        int count = indent;
        while (count > 0) {
            Console.print("   ");
            --count;
        }
        int bsstart = backingStoreProvider.delegate.getBase() + backingStoreProvider.delegate.getSize();
        Console.print(String.valueOf(backingStoreProvider.delegate.getName()) + "[used " + backingStoreProvider.delegate.consumedMemory() + " of " + backingStoreProvider.delegate.getSize());
        int bssize = backingStoreProvider.reservedEnd - bsstart;
        if (bssize > 0) {
            int consumedBackingStore = backingStoreProvider.maxUsage > 0 ? backingStoreProvider.maxUsage - bsstart : 0;
            Console.println(", used " + consumedBackingStore + " of " + bssize + "]");
        } else {
            Console.println("]");
        }
        while (current != null) {
            MemoryArea.print(current, indent + 1);
            current = current.nextContainedMemory;
        }
    }
}

