/*
 * Decompiled with CFR 0.152.
 */
package io;

import devices.CR16C.KT4585.CR16CInterruptDispatcher;
import devices.CR16C.KT4585.DeviceRegShort;
import icecaptools.IcecapCompileMe;
import java.io.IOException;
import test.CR16C.DeviceRegByte;
import util.CircularBuffer;
import vm.InterruptDispatcher;
import vm.InterruptHandler;

public class UARTWriter
implements InterruptHandler {
    private static final short UART_TI_INT_PRIO = 112;
    private static final short MAX_BUFFER = 32;
    private CircularBuffer cbuf = new CircularBuffer(32);
    DeviceRegShort uart_clear_tx_int_reg = new DeviceRegShort(16730372);
    DeviceRegShort uart_ctrl_reg = new DeviceRegShort(16730368);
    DeviceRegShort int2_priority_reg;
    DeviceRegByte uart_rx_tx_reg = new DeviceRegByte(16730370);

    public UARTWriter() {
        this.int2_priority_reg = new DeviceRegShort(16733192);
        this.int2_priority_reg.reg = (short)(this.int2_priority_reg.reg | 0x70);
        this.uart_ctrl_reg.reg = (short)(this.uart_ctrl_reg.reg | 0xC);
    }

    public short capacity() {
        return 32;
    }

    @Override
    @IcecapCompileMe
    public void handle() {
        if (!this.cbuf.isEmpty()) {
            try {
                this.uart_rx_tx_reg.reg = this.cbuf.read();
            }
            catch (IOException e) {
                this.uart_rx_tx_reg.reg = 0;
            }
            this.uart_ctrl_reg.reg = (short)(this.uart_ctrl_reg.reg | 2);
        }
        this.uart_clear_tx_int_reg.reg = 0;
    }

    public void write(String str) throws IOException {
        if (str != null) {
            int length = str.length();
            int i = 0;
            while (i < length) {
                this.cbuf.write(str.charAt(i));
                i = (byte)(i + 1);
            }
        } else {
            throw new IllegalArgumentException("str is null");
        }
        this.handle();
    }

    public void write(byte b) {
        try {
            if (this.cbuf.isFull()) {
                this.flush();
                while (this.cbuf.isFull()) {
                }
            }
            this.cbuf.write(b);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flush() {
        this.handle();
    }

    public void writeLong(long number) {
        this.writeInt((int)(number >> 32));
        this.writeInt((int)(number & 0xFFFFFFFFFFFFFFFFL));
    }

    public void writeInt(int number) {
        this.writeShort((short)(number >> 16));
        this.writeShort((short)(number & 0xFFFF));
    }

    public void writeShort(short number) {
        this.writeByte((byte)(number >> 8));
        this.writeByte((byte)(number & 0xFF));
    }

    public void writeByte(byte number) {
        this.writeNibble((byte)((number & 0xF0) >> 4));
        this.writeNibble((byte)(number & 0xF));
    }

    private void writeNibble(byte number) {
        if (number < 10) {
            this.write((byte)(48 + number));
        } else {
            this.write((byte)(65 + (number - 10)));
        }
    }

    @Override
    public void register() {
        CR16CInterruptDispatcher.init();
        InterruptDispatcher.registerHandler(this, (byte)21);
    }

    @Override
    public void enable() {
    }

    @Override
    public void disable() {
    }
}

