/*
 * Decompiled with CFR 0.152.
 */
package gc;

import util.ReferenceIterator;
import util.ReferenceList;

public class BitMap {
    public static final byte WHITE = 3;
    public static final byte GREY = 1;
    public static final byte BLACK = 2;
    public static final byte HATCHED = 0;
    private int blockSize;
    private int startAdr;
    private int heapSize;
    private int bitMapSize;
    private byte[] bitMap;

    public BitMap(int blockSize, int startAdr, int heapSize) {
        this.blockSize = blockSize;
        this.startAdr = startAdr;
        if (heapSize > 64000) {
            heapSize = 64000;
        }
        this.heapSize = heapSize;
        this.bitMapSize = heapSize / blockSize / 4 + 1;
        this.bitMap = new byte[this.bitMapSize];
    }

    public void clear() {
        int i = 0;
        while (i < this.bitMap.length) {
            this.bitMap[i] = 0;
            ++i;
        }
    }

    public boolean isRefWhite(int ref) {
        int offSet;
        int index = this.getIndex(ref);
        return (this.bitMap[index] & 1 << ((offSet = this.getOffset(ref)) << 1)) != 0 && (this.bitMap[index] & 1 << (offSet << 1) + 1) != 0;
    }

    public boolean isRefGrey(int ref) {
        int offSet;
        int index = this.getIndex(ref);
        return (this.bitMap[index] & 1 << ((offSet = this.getOffset(ref)) << 1)) != 0 && (this.bitMap[index] & 1 << (offSet << 1) + 1) == 0;
    }

    public boolean isRefBlack(int ref) {
        int offSet;
        int index = this.getIndex(ref);
        return (this.bitMap[index] & 1 << ((offSet = this.getOffset(ref)) << 1)) == 0 && (this.bitMap[index] & 1 << (offSet << 1) + 1) != 0;
    }

    public boolean isRefHatched(int ref) {
        int offSet;
        int index = this.getIndex(ref);
        return (this.bitMap[index] & 1 << ((offSet = this.getOffset(ref)) << 1)) == 0 && (this.bitMap[index] & 1 << (offSet << 1) + 1) == 0;
    }

    public void shadeRefGrey(int ref) {
        int index = this.getIndex(ref);
        int offSet = this.getOffset(ref);
        this.bitMap[index] = (byte)(this.bitMap[index] | 1 << (offSet << 1));
        this.bitMap[index] = (byte)(this.bitMap[index] & ~(1 << (offSet << 1) + 1));
    }

    private int getOffset(int ref) {
        return (ref - this.startAdr) / this.blockSize & 3;
    }

    private int getIndex(int ref) {
        return (ref - this.startAdr) / this.blockSize >> 2;
    }

    public void shadeRefWhite(int ref) {
        int index = this.getIndex(ref);
        int offSet = this.getOffset(ref);
        this.bitMap[index] = (byte)(this.bitMap[index] | 1 << (offSet << 1));
        this.bitMap[index] = (byte)(this.bitMap[index] | 1 << (offSet << 1) + 1);
    }

    public void shadeRefBlack(int ref) {
        int index = this.getIndex(ref);
        int offSet = this.getOffset(ref);
        this.bitMap[index] = (byte)(this.bitMap[index] & ~(1 << (offSet << 1)));
        this.bitMap[index] = (byte)(this.bitMap[index] | 1 << (offSet << 1) + 1);
    }

    public ReferenceIterator getFreeList() {
        ReferenceList freeList = new ReferenceList();
        int i = 0;
        while (i < this.bitMap.length) {
            byte nextByte = this.bitMap[i];
            if (nextByte != 0) {
                int ref = (i << 2) * this.blockSize + this.startAdr;
                int j = 0;
                while (j < 4) {
                    if (this.isRefWhite(ref)) {
                        freeList.add(ref);
                        this.shadeRefHatched(ref);
                    } else if (this.isRefBlack(ref)) {
                        this.shadeRefWhite(ref);
                    }
                    ref += this.blockSize;
                    ++j;
                }
            }
            ++i;
        }
        return freeList.iterator();
    }

    private void shadeRefHatched(int ref) {
        int index = this.getIndex(ref);
        int offSet = this.getOffset(ref);
        this.bitMap[index] = (byte)(this.bitMap[index] & ~(1 << (offSet << 1)));
        this.bitMap[index] = (byte)(this.bitMap[index] & ~(1 << (offSet << 1) + 1));
    }

    public boolean isWithinRangeOfHeap(int possibleRef) {
        return possibleRef >= this.startAdr && possibleRef < this.startAdr + this.heapSize;
    }

    public int getSize() {
        return this.bitMapSize;
    }
}

