/*
 * Decompiled with CFR 0.152.
 */
package devices.ev3.support;

import devices.Console;
import devices.ev3.EV3;
import devices.ev3.Motor;

public class EV3Support {
    static int[] commandInfo;
    static Motor[] motors;
    char command = '\u0000';
    int speed = -1;
    int left_side_motor_num = -1;
    int duration = -1;

    public EV3Support(Motor[] m) {
        commandInfo = new int[3];
        motors = m;
    }

    public void getCommand(String msg) {
        this.command = msg.charAt(0);
        if (this.command == 'S' || this.command == 'P') {
            this.duration = this.getCommandInfo(msg.substring(2), 1)[0];
        } else if (this.command == 'F' || this.command == 'B' || this.command == 'C') {
            int[] generated = this.getCommandInfo(msg.substring(2), 2);
            this.speed = generated[0];
            this.duration = generated[1];
        } else {
            int[] generated = this.getCommandInfo(msg.substring(2), 3);
            this.speed = generated[0];
            this.left_side_motor_num = generated[1];
            this.duration = generated[2];
        }
        if ((this.command == 'L' || this.command == 'R') && this.left_side_motor_num == -1) {
            Console.println("wrong command, do not specify the number of left side motors");
            return;
        }
        if ((this.command == 'F' || this.command == 'B' || this.command == 'C') && this.speed == -1) {
            Console.println("wrong command, do not specify the number of left side motors");
            return;
        }
    }

    public void action() {
        int i;
        switch (this.command) {
            case 'F': {
                i = 0;
                while (i < motors.length) {
                    motors[i].setPower((byte)this.speed);
                    motors[i].setDirection(Motor.Direction.FORWARD);
                    motors[i].start();
                    ++i;
                }
                break;
            }
            case 'B': {
                i = 0;
                while (i < motors.length) {
                    motors[i].setPower((byte)this.speed);
                    motors[i].setDirection(Motor.Direction.BACKWARD);
                    motors[i].start();
                    ++i;
                }
                break;
            }
            case 'S': {
                i = 0;
                while (i < motors.length) {
                    motors[i].start();
                    ++i;
                }
                break;
            }
            case 'P': {
                i = 0;
                while (i < motors.length) {
                    motors[i].stop();
                    ++i;
                }
                break;
            }
            case 'C': {
                i = 0;
                while (i < motors.length) {
                    motors[i].setPower((byte)this.speed);
                    ++i;
                }
                break;
            }
            case 'L': {
                i = 0;
                while (i < motors.length) {
                    motors[i].setPower((byte)this.speed);
                    if (i < this.left_side_motor_num) {
                        motors[i].setDirection(Motor.Direction.FORWARD);
                    } else {
                        motors[i].setDirection(Motor.Direction.BACKWARD);
                    }
                    motors[i].start();
                    ++i;
                }
                break;
            }
            case 'R': {
                i = 0;
                while (i < motors.length) {
                    motors[i].setPower((byte)this.speed);
                    if (i < this.left_side_motor_num) {
                        motors[i].setDirection(Motor.Direction.BACKWARD);
                    } else {
                        motors[i].setDirection(Motor.Direction.FORWARD);
                    }
                    motors[i].start();
                    ++i;
                }
                break;
            }
            default: {
                Console.println("undefined command!: " + this.command);
            }
        }
        if (this.duration > 0) {
            EV3.sleep(this.duration * 1000);
            i = 0;
            while (i < motors.length) {
                motors[i].stop();
                ++i;
            }
        }
    }

    public String generateCommand(char command, int speed, int numOfLeftMotors, int duration) {
        String com = String.valueOf(command) + "|" + speed + "|" + numOfLeftMotors + "|" + duration;
        return com;
    }

    public String generateCommand(char command, int speed, int duration) {
        String com = String.valueOf(command) + "|" + speed + "|" + duration;
        return com;
    }

    public String generateCommand(char command, int duration) {
        String com = String.valueOf(command) + "|" + duration;
        return com;
    }

    private int[] getCommandInfo(String info, int count) {
        String speed = "";
        String letfMotor = "";
        String duration = "";
        int i = 0;
        switch (count) {
            case 1: {
                while (i < info.length()) {
                    duration = String.valueOf(duration) + info.charAt(i);
                    ++i;
                }
                EV3Support.commandInfo[0] = this.convert(duration);
                break;
            }
            case 2: {
                while (i < info.length()) {
                    if (info.charAt(i) == '|') break;
                    speed = String.valueOf(speed) + info.charAt(i);
                    ++i;
                }
                ++i;
                while (i < info.length()) {
                    duration = String.valueOf(duration) + info.charAt(i);
                    ++i;
                }
                EV3Support.commandInfo[0] = this.convert(speed);
                EV3Support.commandInfo[1] = this.convert(duration);
                break;
            }
            case 3: {
                while (i < info.length()) {
                    if (info.charAt(i) == '|') break;
                    speed = String.valueOf(speed) + info.charAt(i);
                    ++i;
                }
                ++i;
                while (i < info.length()) {
                    if (info.charAt(i) == '|') break;
                    letfMotor = String.valueOf(letfMotor) + info.charAt(i);
                    ++i;
                }
                ++i;
                while (i < info.length()) {
                    duration = String.valueOf(duration) + info.charAt(i);
                    ++i;
                }
                EV3Support.commandInfo[0] = this.convert(speed);
                EV3Support.commandInfo[1] = this.convert(letfMotor);
                EV3Support.commandInfo[2] = this.convert(duration);
            }
        }
        return commandInfo;
    }

    private int convert(String s) {
        if (s == null || s.length() == 0) {
            return -1;
        }
        int ret = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (i == 0 && c == '-') {
                return -1;
            }
            if (c - 48 < 0 || c - 48 > 10) {
                Console.println("wrong command: should be int here: " + s);
                throw new IllegalArgumentException();
            }
            int tmp = c - 48;
            ret *= 10;
            ret += tmp;
            ++i;
        }
        return ret;
    }

    static interface Command {
        public static final char FORWARD = 'F';
        public static final char BACKFORD = 'B';
        public static final char TURNLEFT = 'L';
        public static final char TURNRIGHT = 'R';
        public static final char START = 'S';
        public static final char STOP = 'P';
        public static final char CHANGESPEED = 'C';
    }
}

