/*
 * Decompiled with CFR 0.152.
 */
package devices.CR16C.KT4585;

import devices.Console;
import io.UARTWriter;
import util.IL2ErrorHandler;
import util.L2Channel;

public class UARTL2Channel
extends L2Channel {
    protected static final byte MESSAGE = 66;
    protected UARTWriter writer = new UARTWriter();

    public UARTL2Channel() {
        super(new UARTChannelErrorHandler());
        this.writer.register();
    }

    @Override
    public void send_callback(byte[] msg, short length) {
        short index = 0;
        while (index < length) {
            this.writer.write(msg[index]);
            index = (byte)(index + 1);
        }
        this.writer.flush();
    }

    public void write(String string) {
        int length = string.length();
        if (this.prologue((short)(length = (short)(length + 1)))) {
            int bufferIndex = 0;
            this.write((byte)66);
            length = (short)(length - 1);
            while (bufferIndex < length) {
                this.write((byte)string.charAt(bufferIndex));
                ++bufferIndex;
            }
            this.epilogue();
        }
    }

    private static class UARTChannelErrorHandler
    implements IL2ErrorHandler {
        private UARTChannelErrorHandler() {
        }

        @Override
        public void errorOccurred(String errorString, byte offendingByte) {
            Console.println(errorString);
        }
    }
}

