import javax.realtime.AperiodicParameters;
import javax.realtime.PriorityParameters;
import javax.safetycritical.AperiodicEvent;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageConfigurationParameters;

public class FireHandler extends AperiodicEventHandler {

	/*
	 * Reference to MissionMemory
	 */
	private Barrier barrier;
	private int id;

	public FireHandler(AperiodicEvent fire1, Barrier barrier, int id) {
		
		super(//priority
			  new PriorityParameters(PriorityScheduler.instance().getMaxPriority()),
			  //release
			  new AperiodicParameters(),
			  //storage
			  new StorageConfigurationParameters(32768, 4096, 4096),
			  //event
			  fire1,
			  //name
			  "FireHandler"+id
		      );
		
		this.barrier = barrier;
		this.id = id;
	}

	public void handleEvent() {
			System.out.println("\n** Fire2 is now handling a 'fire2' the event **");
			
			/*
			 * If we have already triggered the barrier,
			 * do not retrigger
			 */
			if (barrier.isAlreadyTriggered(this.id)) return;
			
			barrier.trigger(this.id);
	}

}
