import javax.realtime.InaccessibleAreaException;
import javax.realtime.MemoryArea;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.RealtimeThread;
import javax.realtime.RelativeTime;
import javax.safetycritical.AperiodicEvent;
import javax.safetycritical.ManagedMemory;
import javax.safetycritical.MissionMemory;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageConfigurationParameters;


public class Producer extends PeriodicEventHandler {
	/*
	 * Event to trigger Consumer
	 */
	private AperiodicEvent consume;
	
	/*
	 * Keep a reference to the last object created
	 */
	private Object data;
	
	/*
	 * Limit the total number of objects to avoid running out of memory in MissionMemory
	 */
	private final int MAX_NUM_OF_OBJECTS = 5;
	private int NUM_OF_OBJECTS = 0;

	private Buffer buffer;

	private Runnable _switch = new Runnable(){
		public void run() {
			Producer.this.data = new Object();
		}		
	};

	
// (annotations turned off to work with Java 1.4)     @SCJAllowed(LEVEL_1)	
	public Producer(AperiodicEvent consume, Buffer buffer) {
		
		super(//priority
			  new PriorityParameters(PriorityScheduler.instance().getNormPriority()),
			  //period
			  new PeriodicParameters(null, new RelativeTime(3000, 0)),
			  //storage
			  new StorageConfigurationParameters(32768, 4096, 4096),
			  //size
			  65523,
			  //name
			  "Producer"
		      );
		
		this.consume = consume;
		this.buffer = buffer;
	}
	
	public void handleEvent() {
		System.out.println("** Producer **");
		System.out.println("2.1 ProducerPrivate : " + ((ManagedMemory) RealtimeThread.getCurrentMemoryArea()).toString());
		
		/*
		 * Limit the creation of new objects to avoid running out of Mission Memory
		 */
		if (NUM_OF_OBJECTS <= MAX_NUM_OF_OBJECTS)
		{
			/*
			 * Allocate new data object and update count
			 */
			try {
				this.data = ManagedMemory.executeInOuter(this._switch);
			} catch (IllegalAccessException e1) {
				System.out.println("2.3 Exception while trying to allocate new object in MissionMemory");
				System.out.println("2.3 Aboring current release");
				return;
			} catch (IllegalArgumentException e1) {
				// TODO Auto-generated catch block
				System.out.println("2.3 Exception while trying to allocate new object in MissionMemory");
				System.out.println("2.3 Aboring current release");
				return;
			} catch (InstantiationException e1) {
				System.out.println("2.3 Exception while trying to allocate new object in MissionMemory");
				System.out.println("2.3 Aboring current release");
				return;
			} catch (OutOfMemoryError e1) {
				// TODO Auto-generated catch block
				System.out.println("2.3 Exception while trying to allocate new object in MissionMemory");
				System.out.println("2.3 Aboring current release");
				return;
			} catch (ExceptionInInitializerError e1) {
				// TODO Auto-generated catch block
				System.out.println("2.3 Exception while trying to allocate new object in MissionMemory");
				System.out.println("2.3 Aboring current release");
				return;
			} catch (InaccessibleAreaException e1) {
				// TODO Auto-generated catch block
				System.out.println("2.3 Exception while trying to allocate new object in MissionMemory");
				System.out.println("2.3 Aboring current release");
				return;
			}
			
			NUM_OF_OBJECTS++;
			
			System.out.println("2.3 New Object[" + NUM_OF_OBJECTS +"] is in : " + (MemoryArea.getMemoryArea(data).toString()));
			
			/*
			 * Store a reference to the new object in the buffer
			 */
			this.buffer.put(data);

			/*
			 * Trigger the Consumer handler
			 */
			this.consume.fire();			
		}		
	}
}
