/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.DigestException;
import java.security.MessageDigestSpi;

public class SHA
extends MessageDigestSpi
implements Cloneable {
    private int version = 1;
    private static final int SHA_LENGTH = 20;
    private int[] W = new int[80];
    private long count = 0L;
    private final int countmax = 64;
    private final int countmask = 63;
    private int AA;
    private int BB;
    private int CC;
    private int DD;
    private int EE;
    private final int round1_kt = 1518500249;
    private final int round2_kt = 1859775393;
    private final int round3_kt = -1894007588;
    private final int round4_kt = -899497514;

    private SHA(SHA sHA) {
        this();
        this.version = sHA.version;
        System.arraycopy(sHA.W, 0, this.W, 0, this.W.length);
        this.count = sHA.count;
        this.AA = sHA.AA;
        this.BB = sHA.BB;
        this.CC = sHA.CC;
        this.DD = sHA.DD;
        this.EE = sHA.EE;
    }

    SHA(int n) {
        this();
        this.version = n;
    }

    public SHA() {
        this.init();
    }

    protected int engineGetDigestLength() {
        return 20;
    }

    public void engineUpdate(byte by) {
        this.engineUpdate((int)by);
    }

    private void engineUpdate(int n) {
        int n2 = ((int)this.count & 0x3F) >>> 2;
        int n3 = (~((int)this.count) & 3) << 3;
        this.W[n2] = this.W[n2] & ~(255 << n3) | (n & 0xFF) << n3;
        if (((int)this.count & 0x3F) == 63) {
            this.computeBlock();
        }
        ++this.count;
    }

    public void engineUpdate(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        while (n2 > 0 && ((int)this.count & 3) != 0) {
            this.engineUpdate(byArray[n]);
            ++n;
            --n2;
        }
        while (n2 >= 4) {
            int n3 = ((int)this.count & 0x3F) >> 2;
            this.W[n3] = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
            this.count += 4L;
            if (((int)this.count & 0x3F) == 0) {
                this.computeBlock();
            }
            n2 -= 4;
            n += 4;
        }
        while (n2 > 0) {
            this.engineUpdate(byArray[n]);
            --n2;
            ++n;
        }
    }

    public void init() {
        this.AA = 1732584193;
        this.BB = -271733879;
        this.CC = -1732584194;
        this.DD = 271733878;
        this.EE = -1009589776;
        for (int i = 0; i < 80; ++i) {
            this.W[i] = 0;
        }
        this.count = 0L;
    }

    public void engineReset() {
        this.init();
    }

    public byte[] engineDigest() {
        byte[] byArray = new byte[20];
        try {
            int n = this.engineDigest(byArray, 0, byArray.length);
        }
        catch (DigestException digestException) {
            throw new InternalError("");
        }
        return byArray;
    }

    public int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < 20) {
            throw new DigestException("partial digests not returned");
        }
        if (byArray.length - n < 20) {
            throw new DigestException("insufficient space in the output buffer to store the digest");
        }
        long l = this.count << 3;
        this.engineUpdate(128);
        while ((int)(this.count & 0x3FL) != 56) {
            this.engineUpdate(0);
        }
        this.W[14] = (int)(l >>> 32);
        this.W[15] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.count += 8L;
        this.computeBlock();
        byArray[n + 0] = (byte)(this.AA >>> 24);
        byArray[n + 1] = (byte)(this.AA >>> 16);
        byArray[n + 2] = (byte)(this.AA >>> 8);
        byArray[n + 3] = (byte)(this.AA >>> 0);
        byArray[n + 4] = (byte)(this.BB >>> 24);
        byArray[n + 5] = (byte)(this.BB >>> 16);
        byArray[n + 6] = (byte)(this.BB >>> 8);
        byArray[n + 7] = (byte)(this.BB >>> 0);
        byArray[n + 8] = (byte)(this.CC >>> 24);
        byArray[n + 9] = (byte)(this.CC >>> 16);
        byArray[n + 10] = (byte)(this.CC >>> 8);
        byArray[n + 11] = (byte)(this.CC >>> 0);
        byArray[n + 12] = (byte)(this.DD >>> 24);
        byArray[n + 13] = (byte)(this.DD >>> 16);
        byArray[n + 14] = (byte)(this.DD >>> 8);
        byArray[n + 15] = (byte)(this.DD >>> 0);
        byArray[n + 16] = (byte)(this.EE >>> 24);
        byArray[n + 17] = (byte)(this.EE >>> 16);
        byArray[n + 18] = (byte)(this.EE >>> 8);
        byArray[n + 19] = (byte)(this.EE >>> 0);
        this.engineReset();
        return 20;
    }

    private void computeBlock() {
        int n;
        int n2;
        for (n2 = 16; n2 <= 79; ++n2) {
            if (this.version == 0) {
                this.W[n2] = this.W[n2 - 3] ^ this.W[n2 - 8] ^ this.W[n2 - 14] ^ this.W[n2 - 16];
                continue;
            }
            n = this.W[n2 - 3] ^ this.W[n2 - 8] ^ this.W[n2 - 14] ^ this.W[n2 - 16];
            this.W[n2] = n << 1 | n >>> 31;
        }
        int n3 = this.AA;
        int n4 = this.BB;
        int n5 = this.CC;
        int n6 = this.DD;
        int n7 = this.EE;
        for (n2 = 0; n2 < 20; ++n2) {
            n = (n3 << 5 | n3 >>> 27) + (n4 & n5 | ~n4 & n6) + n7 + this.W[n2] + 1518500249;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n3;
            n3 = n;
        }
        for (n2 = 20; n2 < 40; ++n2) {
            n = (n3 << 5 | n3 >>> 27) + (n4 ^ n5 ^ n6) + n7 + this.W[n2] + 1859775393;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n3;
            n3 = n;
        }
        for (n2 = 40; n2 < 60; ++n2) {
            n = (n3 << 5 | n3 >>> 27) + (n4 & n5 | n4 & n6 | n5 & n6) + n7 + this.W[n2] + -1894007588;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n3;
            n3 = n;
        }
        for (n2 = 60; n2 < 80; ++n2) {
            n = (n3 << 5 | n3 >>> 27) + (n4 ^ n5 ^ n6) + n7 + this.W[n2] + -899497514;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n3;
            n3 = n;
        }
        this.AA += n3;
        this.BB += n4;
        this.CC += n5;
        this.DD += n6;
        this.EE += n7;
    }

    public Object clone() {
        SHA sHA = null;
        try {
            sHA = (SHA)super.clone();
            sHA.W = new int[80];
            System.arraycopy(this.W, 0, sHA.W, 0, this.W.length);
            return sHA;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return sHA;
        }
    }
}

