/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import java.util.Iterator;
import javax.realtime.AperiodicParameters;
import javax.realtime.AsyncEventHandler;
import javax.realtime.FeasibilityEntry;
import javax.realtime.MemoryArea;
import javax.realtime.MemoryParameters;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityScheduler;
import javax.realtime.ProcessingGroupParameters;
import javax.realtime.RealtimeSystem;
import javax.realtime.RealtimeThread;
import javax.realtime.RecycleBin;
import javax.realtime.RecyclingFeasibilitySet;
import javax.realtime.ReleaseParameters;
import javax.realtime.Schedulable;
import javax.realtime.SchedulingParameters;
import javax.realtime.SporadicParameters;

public abstract class Scheduler {
    private static RecycleBin recycleBin = new RecycleBin(MemoryArea.getEffImmortalMa());
    static RecyclingFeasibilitySet feasibilitySet = new RecyclingFeasibilitySet(recycleBin);
    private static Scheduler defaultScheduler = PriorityScheduler.instance();
    private float LOAD_LIMIT = 0.8f;

    protected Scheduler() {
    }

    protected abstract boolean addToFeasibility(Schedulable var1);

    public abstract boolean setIfFeasible(Schedulable var1, ReleaseParameters var2, MemoryParameters var3);

    public abstract boolean setIfFeasible(Schedulable var1, ReleaseParameters var2, MemoryParameters var3, ProcessingGroupParameters var4);

    public abstract boolean setIfFeasible(Schedulable var1, SchedulingParameters var2, ReleaseParameters var3, MemoryParameters var4, ProcessingGroupParameters var5);

    public static Scheduler getDefaultScheduler() {
        return defaultScheduler;
    }

    public abstract String getPolicyName();

    public abstract boolean isFeasible();

    protected abstract boolean removeFromFeasibility(Schedulable var1);

    public static void setDefaultScheduler(Scheduler scheduler) {
        RealtimeSystem.getSecurityManager().checkSetDefaultScheduler();
        defaultScheduler = scheduler;
    }

    public static boolean isCallerAnSo() {
        Thread thread = Thread.currentThread();
        return thread instanceof RealtimeThread;
    }

    public static Schedulable getCurrentSo() {
        if (Scheduler.isCallerAnSo()) {
            RealtimeThread realtimeThread = RealtimeThread.currentRealtimeThread();
            AsyncEventHandler asyncEventHandler = realtimeThread.getAssociatedAEH();
            if (asyncEventHandler == null) {
                return realtimeThread;
            }
            return asyncEventHandler;
        }
        throw new ClassCastException("Caller is a Java thread");
    }

    static RealtimeThread getRtt(Schedulable schedulable) {
        if (schedulable instanceof AsyncEventHandler) {
            return ((AsyncEventHandler)schedulable).aehImpl.handlerThread;
        }
        if (schedulable instanceof RealtimeThread) {
            return (RealtimeThread)schedulable;
        }
        throw new IllegalArgumentException("schedulable must be an AEH or an RTT");
    }

    public abstract void fireSchedulable(Schedulable var1);

    boolean inFeasibility(Schedulable schedulable) {
        return feasibilitySet.contains(schedulable);
    }

    boolean validParameters(SchedulingParameters schedulingParameters) {
        return false;
    }

    boolean validParameters(ReleaseParameters releaseParameters, ProcessingGroupParameters processingGroupParameters) {
        return false;
    }

    boolean validParameters(ReleaseParameters releaseParameters) {
        return false;
    }

    private float getSchedulableLoad(Schedulable schedulable) {
        return this.getSchedulableLoad(schedulable.getReleaseParameters(), schedulable.getProcessingGroupParameters());
    }

    private float getSchedulableLoad(ReleaseParameters releaseParameters, ProcessingGroupParameters processingGroupParameters) {
        float f = 0.0f;
        if (releaseParameters != null) {
            if (releaseParameters instanceof PeriodicParameters) {
                PeriodicParameters periodicParameters = (PeriodicParameters)releaseParameters;
                if (periodicParameters.getCost() != null && periodicParameters.getPeriod() != null) {
                    long l = periodicParameters.getCostMillis() * 1000L * 1000L;
                    long l2 = periodicParameters.getPeriodMillis() * 1000L * 1000L;
                    f += (float)(l += (long)periodicParameters.getCostNanos()) * 1.0f / ((float)(l2 += (long)periodicParameters.getPeriodNanos()) * 1.0f);
                }
            } else if (releaseParameters instanceof SporadicParameters) {
                SporadicParameters sporadicParameters = (SporadicParameters)releaseParameters;
                if (sporadicParameters.getCost() != null && sporadicParameters.getMinimumInterarrival() != null) {
                    long l = sporadicParameters.getCostMillis() * 1000L * 1000L;
                    long l3 = sporadicParameters.getMitMillis() * 1000L * 1000L;
                    f += (float)(l += (long)sporadicParameters.getCostNanos()) * 1.0f / ((float)(l3 += (long)sporadicParameters.getMitNanos()) * 1.0f);
                }
            } else {
                f += 2.0f;
            }
        }
        return f;
    }

    private float getSchedulableLoad(FeasibilityEntry feasibilityEntry) {
        float f = 0.0f;
        long l = feasibilityEntry.costMs * 1000L * 1000L;
        l += (long)feasibilityEntry.costNs;
        if (feasibilityEntry.type == 1) {
            long l2 = feasibilityEntry.periodMs * 1000L * 1000L;
            f += (float)l * 1.0f / ((float)(l2 += (long)feasibilityEntry.periodNs) * 1.0f);
        } else if (feasibilityEntry.type == 2) {
            long l3 = feasibilityEntry.mitMs * 1000L * 1000L;
            f += (float)l * 1.0f / ((float)(l3 += (long)feasibilityEntry.mitNs) * 1.0f);
        } else {
            f += 2.0f;
        }
        return f;
    }

    float getLoad() {
        float f = 0.0f;
        try {
            Iterator iterator = feasibilitySet.iterator();
            while (iterator.hasNext()) {
                float f2 = 0.0f;
                FeasibilityEntry feasibilityEntry = (FeasibilityEntry)iterator.next();
                f2 = this.getSchedulableLoad(feasibilityEntry);
                f += f2;
            }
        }
        catch (Throwable throwable) {
            f = 0.0f;
        }
        return f;
    }

    boolean internalSetIfFeasible(Schedulable schedulable, ReleaseParameters releaseParameters, MemoryParameters memoryParameters) {
        if (schedulable == null) {
            throw new IllegalArgumentException("Null schedulable");
        }
        return this.internalSetIfFeasible(schedulable, releaseParameters, memoryParameters, schedulable.getProcessingGroupParameters());
    }

    boolean internalSetIfFeasible(Schedulable schedulable, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) {
        if (schedulable == null) {
            throw new IllegalArgumentException("Null schedulable");
        }
        return this.internalSetIfFeasible(schedulable, schedulable.getSchedulingParameters(), releaseParameters, memoryParameters, processingGroupParameters);
    }

    boolean internalSetIfFeasible(Schedulable schedulable, SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) {
        if (schedulable == null) {
            throw new IllegalArgumentException("Null schedulable");
        }
        if (!this.validParameters(releaseParameters, processingGroupParameters)) {
            throw new IllegalArgumentException("Argument values out of range");
        }
        if (!this.validParameters(schedulingParameters)) {
            throw new IllegalArgumentException("Argument values out of range");
        }
        if (releaseParameters instanceof AperiodicParameters && !(releaseParameters instanceof SporadicParameters)) {
            return false;
        }
        SchedulingParameters schedulingParameters2 = schedulable.getSchedulingParameters();
        ReleaseParameters releaseParameters2 = schedulable.getReleaseParameters();
        MemoryParameters memoryParameters2 = schedulable.getMemoryParameters();
        ProcessingGroupParameters processingGroupParameters2 = schedulable.getProcessingGroupParameters();
        float f = 0.0f;
        if (feasibilitySet.contains(schedulable)) {
            f = this.getSchedulableLoad(schedulable);
        }
        schedulable.setSchedulingParameters(schedulingParameters);
        schedulable.setReleaseParameters(releaseParameters);
        schedulable.setMemoryParameters(memoryParameters);
        schedulable.setProcessingGroupParameters(processingGroupParameters);
        float f2 = this.getLoad() + this.getSchedulableLoad(schedulable) - f;
        if (f2 <= this.LOAD_LIMIT) {
            this.internalAddToFeasibility(schedulable);
            return true;
        }
        schedulable.setSchedulingParameters(schedulingParameters2);
        schedulable.setReleaseParameters(releaseParameters2);
        schedulable.setMemoryParameters(memoryParameters2);
        schedulable.setProcessingGroupParameters(processingGroupParameters2);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean internalAddToFeasibility(Schedulable schedulable) {
        if (schedulable == null) {
            throw new IllegalArgumentException("Null schedulable");
        }
        if (!this.validParameters(schedulable.getReleaseParameters(), schedulable.getProcessingGroupParameters())) {
            throw new IllegalArgumentException("Argument values out of range");
        }
        if (schedulable.getScheduler() != this) {
            throw new IllegalArgumentException("Schedulable not associated with this scheduler.");
        }
        Scheduler scheduler = this;
        synchronized (scheduler) {
            if (!feasibilitySet.contains(schedulable)) {
                feasibilitySet.add(schedulable);
                return this.isFeasible();
            }
        }
        return this.isFeasible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean internalSetInFeasibility(Schedulable schedulable) {
        if (schedulable == null) {
            throw new IllegalArgumentException("Null schedulable");
        }
        if (!this.validParameters(schedulable.getReleaseParameters(), schedulable.getProcessingGroupParameters())) {
            throw new IllegalArgumentException("Argument values out of range");
        }
        if (schedulable.getScheduler() != this) {
            throw new IllegalArgumentException("Schedulable not associated with this scheduler.");
        }
        Scheduler scheduler = this;
        synchronized (scheduler) {
            FeasibilityEntry feasibilityEntry = feasibilitySet.get(schedulable);
            if (feasibilityEntry == null) {
                feasibilitySet.add(schedulable);
            } else {
                feasibilityEntry.updateFromSO(schedulable);
            }
        }
        return this.isFeasible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean internalRemoveFromFeasibility(Schedulable schedulable) {
        if (schedulable == null) {
            throw new IllegalArgumentException("null schedulable passed");
        }
        Scheduler scheduler = this;
        synchronized (scheduler) {
            if (feasibilitySet == null || !feasibilitySet.contains(schedulable)) {
                return false;
            }
            feasibilitySet.remove(schedulable);
            return this.isFeasible();
        }
    }

    boolean setReleaseParametersIfFeasible(ReleaseParameters releaseParameters, long l) {
        float f = 0.0f;
        if (feasibilitySet.contains(l)) {
            f = this.getSchedulableLoad((FeasibilityEntry)feasibilitySet.get(l));
            float f2 = this.getLoad() + this.getSchedulableLoad(releaseParameters, null) - f;
            System.out.println(f2);
            if (f2 <= this.LOAD_LIMIT) {
                FeasibilityEntry feasibilityEntry = (FeasibilityEntry)feasibilitySet.get(l);
                feasibilityEntry.setReleaseParameters(releaseParameters);
                return true;
            }
            return false;
        }
        throw new RuntimeException("In Scheduler.setReleaseParametersIfFeasible() with an SO not in feasible set.");
    }

    void setReleaseParametersInFeasibility(ReleaseParameters releaseParameters, long l) {
        if (feasibilitySet.contains(l)) {
            System.out.println("x");
            FeasibilityEntry feasibilityEntry = (FeasibilityEntry)feasibilitySet.get(l);
            feasibilityEntry.setReleaseParameters(releaseParameters);
        }
    }

    void updateReleaseParameters(ReleaseParameters releaseParameters, long l) {
        if (feasibilitySet.contains(l)) {
            FeasibilityEntry feasibilityEntry = (FeasibilityEntry)feasibilitySet.get(l);
            feasibilityEntry.setReleaseParameters(releaseParameters);
        }
    }
}

