/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.CpuTimeClock;
import javax.realtime.GarbageCollector;
import javax.realtime.ImmortalMemory;
import javax.realtime.MarkAndSweepCollector;
import javax.realtime.MemoryArea;
import javax.realtime.MonitorControl;
import javax.realtime.NoDeadlineParams;
import javax.realtime.NoHeapRealtimeThread;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityInheritance;
import javax.realtime.PriorityParameters;
import javax.realtime.PriorityScheduler;
import javax.realtime.RealtimeSecurity;
import javax.realtime.RealtimeSystem;
import javax.realtime.RealtimeThread;
import javax.realtime.RelativeTime;
import javax.realtime.ReleaseParameters;

public final class RealtimeSystem {
    public static final byte BIG_ENDIAN = 1;
    public static final byte LITTLE_ENDIAN;
    public static final byte BYTE_ORDER;
    private static int costMonitoringAverageErrorMarginVal;
    private static GarbageCollector gc;
    private static RealtimeSecurity rs;
    private static boolean securityManagerSet;
    private static int maxConcurrentLocks;
    private static Object measuringLock;
    private static int measuredCostMonitoringError;
    static int softSubset;

    private static native void setMaximumConcurrentLocks0(int var0);

    private static native int getMaximumConcurrentLocks0();

    private static native int getConcurrentLocksUsed0();

    static native int getMPCount0();

    private RealtimeSystem() {
    }

    public static GarbageCollector currentGC() {
        return gc;
    }

    public static int getConcurrentLocksUsed() {
        return RealtimeSystem.getConcurrentLocksUsed0();
    }

    public static int getMaximumConcurrentLocks() {
        return maxConcurrentLocks;
    }

    public static RealtimeSecurity getSecurityManager() {
        return rs;
    }

    public static void setMaximumConcurrentLocks(int n) {
        if (n > 0) {
            RealtimeSystem.setMaximumConcurrentLocks0(n);
            maxConcurrentLocks = n;
        }
    }

    public static void setMaximumConcurrentLocks(int n, boolean bl) {
        if (n > 0) {
            if (bl) {
                RealtimeSystem.setMaximumConcurrentLocks0(n);
                maxConcurrentLocks = n;
            } else {
                maxConcurrentLocks = n;
            }
        }
    }

    public static void setSecurityManager(RealtimeSecurity realtimeSecurity) {
        if (securityManagerSet) {
            throw new SecurityException("Attempt to set the real-time security manager more than once");
        }
        securityManagerSet = true;
        rs = realtimeSecurity;
    }

    public static MonitorControl getInitialMonitorControl() {
        return PriorityInheritance.instance();
    }

    public static boolean isCostMonitoringSupported() {
        return true;
    }

    public static RelativeTime getCostMonitoringResolution(RelativeTime relativeTime) {
        return CpuTimeClock.internalGetResolution((RelativeTime)relativeTime);
    }

    public static RelativeTime getCostMonitoringResolution() {
        return RealtimeSystem.getCostMonitoringResolution(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCostMonitoringAverageErrorMargin() {
        if (costMonitoringAverageErrorMarginVal == -1) {
            costMonitoringAverageErrorMarginVal = Integer.getInteger("javax.realtime.AverageCostMonitoringError", measuredCostMonitoringError);
        } else if (costMonitoringAverageErrorMarginVal == 0) {
            Object object = measuringLock;
            synchronized (object) {
                while (measuredCostMonitoringError == 0) {
                    try {
                        measuringLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
        return costMonitoringAverageErrorMarginVal;
    }

    static boolean isSoftSubsetLExcludeNhOn() {
        if (softSubset < 0) {
            softSubset = RealtimeSystem.getSoftSubsetLevel0();
        }
        return (softSubset & 1) != 0;
    }

    static boolean isSoftSubsetLExcludeAtcOn() {
        if (softSubset < 0) {
            softSubset = RealtimeSystem.getSoftSubsetLevel0();
        }
        return false;
    }

    private static native int getSoftSubsetLevel0();

    static native boolean setAffinity0(long var0);

    static native boolean setAffinityOfThread0(Thread var0, long var1);

    static native long getAffinityOfThread0(Thread var0);

    private static void measureCostMonitoringError() {
        RealtimeThread realtimeThread = new RealtimeThread(null, (ReleaseParameters)NoDeadlineParams.instance()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                RelativeTime relativeTime = new RelativeTime(100L, 0);
                RelativeTime relativeTime2 = new RelativeTime(20L, 0);
                RelativeTime relativeTime3 = RealtimeSystem.getCostMonitoringResolution();
                relativeTime3.set(relativeTime3.getMilliseconds() * 10L, relativeTime3.getNanoseconds() * 10);
                if (relativeTime3.compareTo(relativeTime) < 0) {
                    relativeTime3.set(relativeTime);
                }
                class MeasuringLogic
                implements Runnable {
                    static final int SAMPLES = 8;
                    public long[] ct;
                    RelativeTime bound;

                    MeasuringLogic(RelativeTime relativeTime) {
                        this.ct = new long[8];
                        this.bound = relativeTime;
                    }

                    public void run() {
                        RelativeTime relativeTime = new RelativeTime(this.bound);
                        RelativeTime relativeTime2 = new RelativeTime();
                        for (int i = 0; i < 8; ++i) {
                            this.ct[i] = 0L;
                            while (RealtimeThread.getCurrentConsumption(relativeTime2).compareTo(relativeTime) < 0) {
                                int n = i;
                                this.ct[n] = this.ct[n] + 1L;
                            }
                            relativeTime.add(this.bound, relativeTime);
                        }
                    }
                }
                MeasuringLogic measuringLogic = new MeasuringLogic(relativeTime3);
                PriorityParameters priorityParameters = new PriorityParameters(PriorityScheduler.getNormPriority(null) + 5);
                PriorityParameters priorityParameters2 = new PriorityParameters(PriorityScheduler.getNormPriority(null) + 6);
                RealtimeThread realtimeThread = MemoryArea.isSoftSubsetLExcludeNhOn0() ? new RealtimeThread(priorityParameters, (ReleaseParameters)NoDeadlineParams.instance(), null, null, null, measuringLogic) : new NoHeapRealtimeThread(priorityParameters, (ReleaseParameters)NoDeadlineParams.instance(), null, ImmortalMemory.instance(), null, measuringLogic);
                long[] lArray = new long[16];
                realtimeThread.start();
                try {
                    realtimeThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                for (int i = 0; i < measuringLogic.ct.length; ++i) {
                    lArray[i] = measuringLogic.ct[i];
                }
                RelativeTime relativeTime4 = RealtimeSystem.getCostMonitoringResolution();
                relativeTime4.add(relativeTime4, relativeTime4);
                if (relativeTime4.compareTo(relativeTime2) < 0) {
                    relativeTime4.set(relativeTime2);
                }
                PeriodicParameters periodicParameters = new PeriodicParameters(null, relativeTime4);
                class Interrupter
                implements Runnable {
                    boolean stop;

                    Interrupter() {
                        this.stop = false;
                    }

                    public void run() {
                        while (!this.stop) {
                            RealtimeThread.waitForNextPeriod();
                        }
                    }
                }
                Interrupter interrupter = new Interrupter();
                RealtimeThread realtimeThread2 = MemoryArea.isSoftSubsetLExcludeNhOn0() ? new RealtimeThread(priorityParameters2, periodicParameters, null, null, null, interrupter) : new NoHeapRealtimeThread(priorityParameters2, periodicParameters, null, ImmortalMemory.instance(), null, interrupter);
                RealtimeThread realtimeThread3 = MemoryArea.isSoftSubsetLExcludeNhOn0() ? new RealtimeThread(priorityParameters2, periodicParameters, null, null, null, interrupter) : new NoHeapRealtimeThread(priorityParameters2, periodicParameters, null, ImmortalMemory.instance(), null, interrupter);
                RealtimeThread realtimeThread4 = MemoryArea.isSoftSubsetLExcludeNhOn0() ? new RealtimeThread(priorityParameters, (ReleaseParameters)NoDeadlineParams.instance(), null, null, null, measuringLogic) : new NoHeapRealtimeThread(priorityParameters, (ReleaseParameters)NoDeadlineParams.instance(), null, ImmortalMemory.instance(), null, measuringLogic);
                realtimeThread2.start();
                realtimeThread3.start();
                realtimeThread4.start();
                try {
                    realtimeThread4.join();
                    interrupter.stop = true;
                    realtimeThread2.join();
                    realtimeThread3.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                for (int i = 0; i < measuringLogic.ct.length; ++i) {
                    lArray[measuringLogic.ct.length + i] = measuringLogic.ct[i];
                }
                long l = 0L;
                for (int i = 0; i < lArray.length; ++i) {
                    l += lArray[i];
                }
                l /= (long)lArray.length;
                long[] lArray2 = new long[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    lArray2[i] = Math.abs(l - lArray[i]);
                }
                long l2 = 0L;
                for (int i = 0; i < lArray.length; ++i) {
                    if (lArray2[i] <= l2) continue;
                    l2 = lArray2[i];
                }
                long l3 = 0L;
                for (int i = 0; i < lArray2.length; ++i) {
                    l3 += lArray2[i];
                }
                l3 /= (long)lArray2.length;
                float f = (float)l2 / (float)l;
                measuredCostMonitoringError = Math.round(100.0f * f);
                Object object = measuringLock;
                synchronized (object) {
                    measuringLock.notifyAll();
                }
            }
        };
        realtimeThread.start();
    }

    static {
        BYTE_ORDER = LITTLE_ENDIAN = 0;
        costMonitoringAverageErrorMarginVal = -1;
        gc = new MarkAndSweepCollector();
        rs = new RealtimeSecurity();
        securityManagerSet = false;
        maxConcurrentLocks = RealtimeSystem.getMaximumConcurrentLocks0();
        measuringLock = new Object();
        measuredCostMonitoringError = 0;
        RealtimeSystem.measureCostMonitoringError();
        softSubset = -1;
    }
}

