/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.OffsetOutOfBoundsException;
import javax.realtime.RawMemoryAccess;
import javax.realtime.RawScalarAccess;
import javax.realtime.RealtimeSystem;
import javax.realtime.SizeOutOfBoundsException;

public class RawIoAccess
implements RawScalarAccess {
    private static int SIZEOF_BYTE = 1;
    private static int SIZEOF_SHORT = 2;
    private static int SIZEOF_INT = 4;
    private static int SIZEOF_LONG = 8;
    private static int IO_SPACE_SIZE = 65536;
    private int size;

    public RawIoAccess(int n, int n2) throws SecurityException, OffsetOutOfBoundsException, SizeOutOfBoundsException {
        if (n < 0) {
            throw new IllegalArgumentException("Negative base");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Non-positive size");
        }
        if (n > IO_SPACE_SIZE) {
            throw new IllegalArgumentException("base address > 64k");
        }
        if (n2 > IO_SPACE_SIZE) {
            throw new SizeOutOfBoundsException("Size > 64k");
        }
        RealtimeSystem.getSecurityManager().checkAccessPhysical();
        RealtimeSystem.getSecurityManager().checkAccessPhysicalType(RawMemoryAccess.IO_ACCESS);
        if (n + n2 > IO_SPACE_SIZE) {
            throw new OffsetOutOfBoundsException("Base + size > 64k");
        }
        if (RawIoAccess.checkIoAccess0() < 0) {
            throw new SecurityException("Access to I/O space not permited for the JVM");
        }
        this.size = n2;
    }

    private static native int checkIoAccess0();

    public byte getByte(long l) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, SIZEOF_BYTE);
        return this.getByte0((int)l / SIZEOF_BYTE);
    }

    private native byte getByte0(int var1);

    public void getBytes(long l, byte[] byArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, SIZEOF_BYTE, byArray.length, n, n2);
        for (int i = 0; i < n2; ++i) {
            byArray[i + n] = this.getByte(l + (long)i);
        }
    }

    public int getInt(long l) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, SIZEOF_INT);
        return this.getInt0((int)l / SIZEOF_INT);
    }

    private native int getInt0(int var1);

    public void getInts(long l, int[] nArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, SIZEOF_INT, nArray.length, n, n2);
        for (int i = 0; i < n2; ++i) {
            nArray[i + n] = this.getInt(l + (long)(i * SIZEOF_INT));
        }
    }

    public long getLong(long l) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, SIZEOF_LONG);
        throw new UnsupportedOperationException("No long I/O is supported");
    }

    public void getLongs(long l, long[] lArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, SIZEOF_LONG, lArray.length, n, n2);
        throw new UnsupportedOperationException("No long I/O is supported");
    }

    public short getShort(long l) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, SIZEOF_SHORT);
        return this.getShort0((int)l / SIZEOF_SHORT);
    }

    private native short getShort0(int var1);

    public void getShorts(long l, short[] sArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, SIZEOF_SHORT, sArray.length, n, n2);
        for (int i = 0; i < n2; ++i) {
            sArray[i + n] = this.getShort(l + (long)(i * SIZEOF_SHORT));
        }
    }

    public void setByte(long l, byte by) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, SIZEOF_BYTE);
        this.setByte0((int)l / SIZEOF_BYTE, by);
    }

    private native void setByte0(int var1, byte var2);

    public void setBytes(long l, byte[] byArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, SIZEOF_BYTE, byArray.length, n, n2);
        for (int i = 0; i < n2; ++i) {
            this.setByte(l + (long)(i * SIZEOF_BYTE), byArray[i + n]);
        }
    }

    public void setInt(long l, int n) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, SIZEOF_INT);
        this.setInt0((int)l / SIZEOF_INT, n);
    }

    private native void setInt0(int var1, int var2);

    public void setInts(long l, int[] nArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, SIZEOF_INT, nArray.length, n, n2);
        for (int i = 0; i < n2; ++i) {
            this.setInt(l + (long)(i * SIZEOF_INT), nArray[i + n]);
        }
    }

    public void setLong(long l, long l2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, SIZEOF_LONG);
        throw new UnsupportedOperationException("Long operations not supported for I/O space");
    }

    public void setLongs(long l, long[] lArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, SIZEOF_LONG, lArray.length, n, n2);
        throw new UnsupportedOperationException("Long operations not supported for I/O space");
    }

    public void setShort(long l, short s) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, SIZEOF_SHORT);
        this.setShort0((int)l / SIZEOF_SHORT, s);
    }

    private native void setShort0(int var1, short var2);

    public void setShorts(long l, short[] sArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, SIZEOF_SHORT, sArray.length, n, n2);
        for (int i = 0; i < n2; ++i) {
            this.setShort(l + (long)(i * SIZEOF_SHORT), sArray[i + n]);
        }
    }

    void standardChecks(long l, int n) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        RealtimeSystem.getSecurityManager().checkAccessPhysical();
        if (l >= (long)this.size || l < 0L) {
            throw new OffsetOutOfBoundsException("Offset passed is greater than memory size or less than 0");
        }
        if (l + (long)n > (long)this.size) {
            throw new SizeOutOfBoundsException();
        }
        if (l % (long)n != 0L) {
            throw new IllegalArgumentException("Offset must be aligned for I/O space operations");
        }
    }

    void arrayChecks(long l, int n, int n2, int n3, int n4) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        if (n4 + n3 > n2) {
            throw new ArrayIndexOutOfBoundsException("Array passed is not big enough");
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative starting index");
        }
        if (l < 0L) {
            throw new OffsetOutOfBoundsException("offset is negative");
        }
        if (n4 < 0) {
            throw new OffsetOutOfBoundsException("'number' is negative");
        }
        this.standardChecks(l, n * n4);
    }
}

