/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AbsoluteTime;
import javax.realtime.HighResolutionTime;
import javax.realtime.RelativeTime;

public class RationalTime
extends RelativeTime {
    private int frequency;

    public RationalTime(int n) {
        super(1000L, 0);
        if (n <= 0) {
            throw new IllegalArgumentException("Frequency <= 0");
        }
        this.frequency = n;
    }

    public RationalTime(int n, long l, int n2) throws IllegalArgumentException {
        super(l, n2);
        if (n <= 0) {
            throw new IllegalArgumentException("Frequency <= 0");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("milliseconds < 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("nanoseconds < 0");
        }
        this.frequency = n;
    }

    public RationalTime(int n, RelativeTime relativeTime) throws IllegalArgumentException {
        super(relativeTime);
        if (n <= 0) {
            throw new IllegalArgumentException("Frequency <= 0");
        }
        if (relativeTime.getMilliseconds() < 0L) {
            throw new IllegalArgumentException("milliseconds < 0");
        }
        if (relativeTime.getNanoseconds() < 0) {
            throw new IllegalArgumentException("nanoseconds < 0");
        }
        this.frequency = n;
    }

    public void setFrequency(int n) throws ArithmeticException {
        if (n <= 0) {
            throw new IllegalArgumentException("Frequency <= 0");
        }
        this.frequency = n;
    }

    public int getFrequency() {
        return this.frequency;
    }

    void setInterval(long l, int n) {
        this.set(this.frequency, l, n);
    }

    void setInterval(RationalTime rationalTime) {
        this.set(this.frequency, rationalTime.getMilliseconds(), rationalTime.getNanoseconds());
    }

    RelativeTime getInterval(RelativeTime relativeTime) {
        if (relativeTime == null) {
            relativeTime = new RelativeTime();
        }
        relativeTime.set(this.getMilliseconds(), this.getNanoseconds());
        return relativeTime;
    }

    RelativeTime getInterval() {
        return this.getInterval(null);
    }

    void set(int n, long l, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("Frequency not greater than zero");
        }
        if (l < 0L || n2 < 0) {
            throw new IllegalArgumentException("millis/nanos component has to be >= 0");
        }
        this.frequency = n;
        super.set(l, n2, this.clock, false);
    }

    public void set(long l, int n) {
        this.set(1, l, n);
    }

    public void set(long l) {
        this.set(l, 0);
    }

    void set(int n, RationalTime rationalTime) {
        this.set(n, rationalTime.getMilliseconds(), rationalTime.getNanoseconds());
    }

    public RelativeTime getInterarrivalTime(RelativeTime relativeTime) {
        if (relativeTime == null) {
            relativeTime = new RelativeTime();
        }
        relativeTime.milliseconds = this.getMilliseconds() / (long)this.frequency;
        int n = (int)(this.getMilliseconds() % (long)this.frequency);
        int n2 = n * 1000000 + this.getNanoseconds();
        relativeTime.nanoseconds = n2 / this.frequency;
        relativeTime.clock = this.clock;
        return relativeTime;
    }

    public void addInterarrivalTo(AbsoluteTime absoluteTime) {
        RelativeTime relativeTime = this.getInterarrivalTime();
        if (absoluteTime == null) {
            throw new IllegalArgumentException("destination is null");
        }
        absoluteTime.add(relativeTime, absoluteTime);
    }

    public RelativeTime getInterarrivalTime() {
        return this.getInterarrivalTime(null);
    }

    public void set(HighResolutionTime highResolutionTime) {
        if (!(highResolutionTime instanceof RationalTime)) {
            throw new ClassCastException("Object types must match");
        }
        RationalTime rationalTime = (RationalTime)highResolutionTime;
        this.set(rationalTime.getFrequency(), rationalTime.getMilliseconds(), rationalTime.getNanoseconds());
    }

    public String toString() {
        return "(" + this.frequency + ", " + this.milliseconds + " ms, " + this.nanoseconds + " ns)";
    }
}

