/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.NoHeapRealtimeThread;
import javax.realtime.PriorityScheduler;
import javax.realtime.RealtimeThread;
import javax.realtime.SchedRefHolder;
import javax.realtime.SchedulerRefRecycler;
import javax.realtime.SchedulingParameters;

public class PriorityParameters
extends SchedulingParameters {
    int priority;
    private SchedulerRefRecycler soSet = new SchedulerRefRecycler();
    private int useCount = 0;
    private int heapSoCount = 0;

    public PriorityParameters(int n) {
        this.priority = n;
    }

    public int getPriority() {
        return this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void bind(RealtimeThread realtimeThread) {
        if (!(realtimeThread instanceof NoHeapRealtimeThread)) {
            ++this.heapSoCount;
        }
        PriorityParameters priorityParameters = this;
        synchronized (priorityParameters) {
            SchedRefHolder schedRefHolder = this.soSet.find(realtimeThread);
            if (schedRefHolder == null) {
                this.soSet.add(realtimeThread);
                ++this.useCount;
            } else {
                schedRefHolder.execEnv = realtimeThread.getExecEnv();
            }
        }
    }

    void unbind(RealtimeThread realtimeThread) {
        this.soSet.remove(realtimeThread);
        --this.useCount;
        if (!(realtimeThread instanceof NoHeapRealtimeThread)) {
            --this.heapSoCount;
        }
    }

    int boundThreadCount() {
        return this.soSet.size();
    }

    private boolean validRange(int n) throws ClassCastException {
        if (this.soSet.size() > 0) {
            return PriorityScheduler.instance().validPriority(n);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(int n) throws IllegalArgumentException {
        try {
            if (!this.validRange(n)) {
                throw new IllegalArgumentException("Priority (" + n + ") out of range");
            }
        }
        catch (ClassCastException classCastException) {
            return;
        }
        this.priority = n;
        SchedulerRefRecycler schedulerRefRecycler = this.soSet;
        synchronized (schedulerRefRecycler) {
            for (int i = 0; i < this.soSet.size(); ++i) {
                long l = this.soSet.elementAt((int)i).execEnv;
                RealtimeThread.setNativeRealtimePriority((int)l, PriorityScheduler.priorityToRTPriority(n), n);
            }
        }
        if (this.heapSoCount > 0 && PriorityScheduler.getMaxHeapPriorityParameters() != this) {
            PriorityScheduler.instance().updateHeapSOThreshold(n);
        }
    }

    public Object clone() {
        SchedulerRefRecycler schedulerRefRecycler = this.soSet;
        this.soSet = null;
        PriorityParameters priorityParameters = (PriorityParameters)super.clone();
        this.soSet = schedulerRefRecycler;
        this.heapSoCount = 0;
        this.useCount = 0;
        priorityParameters.soSet = new SchedulerRefRecycler();
        return priorityParameters;
    }

    public String toString() {
        return Integer.toString(this.priority);
    }
}

