/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AbsoluteTime;
import javax.realtime.AsyncEventHandler;
import javax.realtime.Clock;
import javax.realtime.HighResolutionTime;
import javax.realtime.LateStartException;
import javax.realtime.MemoryArea;
import javax.realtime.PeriodicParameters;
import javax.realtime.PhasingPolicy;
import javax.realtime.RationalTime;
import javax.realtime.RelativeTime;
import javax.realtime.ReleaseParameters;
import javax.realtime.RichAsyncEventHandler;
import javax.realtime.Timer;

public class PeriodicTimer
extends Timer {
    private boolean isRational = false;
    private RelativeTime relInterval = null;
    private RationalTime ratInterval = null;
    private RelativeTime period = new RelativeTime();
    private AbsoluteTime currentTime = new AbsoluteTime();
    private RelativeTime waitTime = new RelativeTime();
    private AbsoluteTime nextFireTime = new AbsoluteTime();
    private AbsoluteTime lastFireTime = new AbsoluteTime();
    private static CrpBodyType crpBody = new CrpBodyType();

    public PeriodicTimer(HighResolutionTime highResolutionTime, RelativeTime relativeTime, AsyncEventHandler asyncEventHandler) {
        this(highResolutionTime, relativeTime, null, asyncEventHandler);
    }

    public PeriodicTimer(HighResolutionTime highResolutionTime, RelativeTime relativeTime, Clock clock, AsyncEventHandler asyncEventHandler) {
        super(highResolutionTime, clock, asyncEventHandler);
        this.init(relativeTime);
    }

    private void init(RelativeTime relativeTime) {
        if (relativeTime == null) {
            relativeTime = new RelativeTime(0L, 0);
        }
        if (relativeTime instanceof RationalTime) {
            this.isRational = true;
            this.ratInterval = (RationalTime)relativeTime;
        } else {
            this.isRational = false;
            this.relInterval = relativeTime;
        }
        this.period.set(relativeTime.getMilliseconds(), relativeTime.getNanoseconds());
    }

    public void start() {
        this.start(false);
    }

    public void start(PhasingPolicy phasingPolicy) throws LateStartException {
        this.start(false, phasingPolicy);
    }

    void startNoCheck(boolean bl, PhasingPolicy phasingPolicy) throws LateStartException {
        super.start(bl);
        this.hasFired = false;
        this.rescheduleInternal(bl, phasingPolicy);
    }

    public void start(boolean bl, PhasingPolicy phasingPolicy) throws LateStartException {
        if (phasingPolicy == null) {
            throw new IllegalArgumentException("null phasingPolicy");
        }
        if (!this.isAbsolute) {
            throw new IllegalArgumentException("start(phasingPolicy) is not compatible with a relative start time");
        }
        this.startNoCheck(bl, phasingPolicy);
    }

    public void start(boolean bl) {
        super.start(bl);
        this.hasFired = false;
        try {
            this.rescheduleInternal(bl, PhasingPolicy.DEFAULT_PHASING);
        }
        catch (LateStartException lateStartException) {
            throw new RuntimeException("Logic error");
        }
    }

    void reStartInternal() {
        try {
            this.rescheduleInternal(false, PhasingPolicy.DEFAULT_PHASING);
        }
        catch (LateStartException lateStartException) {
            throw new RuntimeException("Logic error");
        }
    }

    public void reschedule(HighResolutionTime highResolutionTime) {
        super.reschedule(highResolutionTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reschedule(AbsoluteTime absoluteTime, PhasingPolicy phasingPolicy) throws LateStartException {
        Object object = this.timerLock;
        synchronized (object) {
            this.checkAlive();
            if (absoluteTime == null) {
                return;
            }
            this.isAbsolute = true;
            this.absfireTime.set(absoluteTime);
            if (this.isRunning && !this.hasFired) {
                this.rescheduleInternal(false, phasingPolicy);
            }
        }
    }

    void reschedule(HighResolutionTime highResolutionTime, RelativeTime relativeTime) {
        this.isRational = false;
        this.relInterval = relativeTime;
        this.period.set(relativeTime.getMilliseconds(), relativeTime.getNanoseconds());
        super.reschedule(highResolutionTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rescheduleInternal(boolean bl, PhasingPolicy phasingPolicy) throws LateStartException {
        Object object = this.timerLock;
        synchronized (object) {
            int n;
            long l;
            this.checkAlive();
            Clock.getRealtimeClock().getTime(this.currentTime);
            if (this.isAbsolute) {
                l = this.absfireTime.getMilliseconds();
                n = this.absfireTime.getNanoseconds();
            } else {
                l = this.relfireTime.getMilliseconds();
                n = this.relfireTime.getNanoseconds();
            }
            long l2 = this.period.getMilliseconds();
            int n2 = this.period.getNanoseconds();
            this.setEnabled(!bl);
            if (this.isAbsolute) {
                this.absfireTime.subtract(this.currentTime, this.waitTime);
                if (this.waitTime.compareToZero() < 0) {
                    if (phasingPolicy == PhasingPolicy.DEFAULT_PHASING) {
                        this.nextFireTime.set(this.currentTime);
                        if (this.period.compareToZero() == 0) {
                            super.tick();
                            return;
                        }
                        this.tick();
                        this.absfireTime.set(this.nextFireTime);
                        l = this.absfireTime.getMilliseconds();
                        n = this.absfireTime.getNanoseconds();
                    } else {
                        if (phasingPolicy == PhasingPolicy.STRICT_PHASING) {
                            throw new LateStartException();
                        }
                        if (phasingPolicy == PhasingPolicy.ADJUST_BACKWARD_PHASING) {
                            long l3 = -this.waitTime.divideBy(l2, n2);
                            if (l3 < 0L) {
                                throw new RuntimeException("periods = " + l3);
                            }
                            this.waitTime.set(l2 * l3, (int)((long)n2 * l3));
                            this.absfireTime.add(this.waitTime, this.nextFireTime);
                            if (this.period.compareToZero() == 0) {
                                super.tick();
                                return;
                            }
                            this.tick();
                            this.absfireTime.set(this.nextFireTime);
                            l = this.absfireTime.getMilliseconds();
                            n = this.absfireTime.getNanoseconds();
                        } else if (phasingPolicy == PhasingPolicy.ADJUST_FORWARD_PHASING) {
                            long l4 = -this.waitTime.divideBy(l2, n2);
                            if (l4 < 0L) {
                                throw new RuntimeException("periods = " + l4);
                            }
                            this.waitTime.set(l2 * ++l4, (int)((long)n2 * l4));
                            this.absfireTime.add(this.waitTime, this.absfireTime);
                            l = this.absfireTime.getMilliseconds();
                            n = this.absfireTime.getNanoseconds();
                        }
                    }
                }
            } else if (this.relfireTime.compareToZero() <= 0) {
                this.nextFireTime.set(this.currentTime);
                this.tick();
                if (this.period.compareToZero() == 0) {
                    return;
                }
                this.isAbsolute = true;
                this.absfireTime.set(this.nextFireTime);
                l = this.absfireTime.getMilliseconds();
                n = this.absfireTime.getNanoseconds();
            }
            if (this.isAbsolute) {
                this.nextFireTime.set(this.absfireTime);
            } else {
                this.currentTime.add(this.relfireTime, this.nextFireTime);
            }
            this.stopTimer();
            this.setTimer(this.jtimerNativeData, this.isAbsolute, l, n, l2, n2);
            Clock.getRealtimeClock().getTime(this.startTime);
            this.setIsRunning(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbsoluteTime getFireTime(AbsoluteTime absoluteTime) {
        Object object = this.timerLock;
        synchronized (object) {
            this.checkAlive();
            if (!this.isRunning) {
                if (!this.isAbsolute) throw new IllegalStateException("Fire time not available--relative time with no start.");
                if (absoluteTime == null) {
                    absoluteTime = new AbsoluteTime();
                }
                absoluteTime.set(this.absfireTime);
            } else {
                if (absoluteTime == null) {
                    absoluteTime = new AbsoluteTime();
                }
                absoluteTime.set(this.nextFireTime);
            }
            return absoluteTime;
        }
    }

    AbsoluteTime internalGetLastReleaseTime(AbsoluteTime absoluteTime) {
        if (!this.started) {
            return null;
        }
        if (absoluteTime == null) {
            absoluteTime = new AbsoluteTime();
        }
        absoluteTime.set(this.lastFireTime);
        return absoluteTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterval(RelativeTime relativeTime) {
        Object object = this.timerLock;
        synchronized (object) {
            this.checkAlive();
            if (relativeTime == null) {
                this.relInterval = new RelativeTime();
                this.isRational = false;
                this.period.set(0L, 0);
            } else {
                if (relativeTime instanceof RationalTime) {
                    this.isRational = true;
                    this.ratInterval = (RationalTime)relativeTime;
                } else {
                    this.isRational = false;
                    this.relInterval = relativeTime;
                }
                this.period.set(relativeTime.getMilliseconds(), relativeTime.getNanoseconds());
            }
            if (this.isRunning) {
                this.reschedule(this.nextFireTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelativeTime getInterval(RelativeTime relativeTime) {
        Object object = this.timerLock;
        synchronized (object) {
            this.checkAlive();
            if (relativeTime == null) {
                relativeTime = new RelativeTime();
            }
            if (this.isRational) {
                relativeTime.set(this.ratInterval);
            } else {
                relativeTime.set(this.relInterval);
            }
            return relativeTime;
        }
    }

    public RelativeTime getInterval() {
        this.checkAlive();
        if (this.isRational) {
            return this.ratInterval;
        }
        return this.relInterval;
    }

    public ReleaseParameters createReleaseParameters() {
        return this.internalCreateReleaseParameters(null);
    }

    public ReleaseParameters createReleaseParameters(ReleaseParameters releaseParameters) {
        return this.internalCreateReleaseParameters(releaseParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReleaseParameters internalCreateReleaseParameters(ReleaseParameters releaseParameters) {
        Object object = this.timerLock;
        synchronized (object) {
            this.checkAlive();
            if (this.period.compareToZero() == 0) {
                return super.createReleaseParameters(releaseParameters);
            }
            if (releaseParameters == null) {
                return new PeriodicParameters(this.getFireTimeValue(), this.getInterval(null), null, null, null, null);
            }
            PeriodicTimer.crpBody.dest = (PeriodicParameters)releaseParameters;
            PeriodicTimer.crpBody.from = this;
            MemoryArea.getMemoryArea(releaseParameters).executeInArea(crpBody);
            return releaseParameters;
        }
    }

    void tick() {
        this.lastFireTime.set(this.nextFireTime);
        this.nextFireTime.add(this.period, this.nextFireTime);
        this.hasFired = true;
        if (this.isEnabled()) {
            this.internalFire(RichAsyncEventHandler.NO_DATA, 0, false);
        }
    }

    static class CrpBodyType
    implements Runnable {
        PeriodicParameters dest;
        PeriodicTimer from;

        CrpBodyType() {
        }

        public void run() {
            this.dest.internalSetAll(this.from.getFireTimeValue(), (RelativeTime)this.from.relInterval.clone(), new RelativeTime(), new RelativeTime(), null, null);
        }
    }
}

