/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.HeapMemory;
import javax.realtime.InaccessibleAreaException;
import javax.realtime.MemoryArea;
import javax.realtime.RealtimeThread;
import javax.realtime.ScopedCycleException;

public final class ImmortalMemory
extends MemoryArea {
    private static final int MEM_SIZE = 0x400000;
    private static ImmortalMemory immortal = null;

    public static synchronized ImmortalMemory instance() {
        if (MemoryArea.isSoftSubsetLExcludeNhOn0()) {
            throw new IllegalStateException("Immortal memory cannot be created in heap-only mode.");
        }
        if (immortal == null) {
            immortal = ImmortalMemory.initImmortal(0x400000L);
        }
        return immortal;
    }

    private ImmortalMemory() {
        super(0x400000L);
        if (MemoryArea.isSoftSubsetLExcludeNhOn0()) {
            throw new IllegalStateException("Immortal memory cannot be created in heap-only mode.");
        }
    }

    boolean reachableMemory() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter(Runnable runnable) throws ScopedCycleException {
        if (runnable == null) {
            throw new IllegalArgumentException("null Runnable");
        }
        MemoryArea memoryArea = MemoryArea.getMemoryArea(runnable);
        if (memoryArea != ImmortalMemory.instance() && memoryArea != HeapMemory.instance() && memoryArea != this && !memoryArea.reachableMemory()) {
            throw new InaccessibleAreaException("Memory area containing logic is accessible from this scope stack.");
        }
        if (Thread.currentThread() instanceof RealtimeThread) {
            this.pushMemoryArea();
            try {
                runnable.run();
            }
            finally {
                this.popMemoryArea();
            }
        } else {
            throw new IllegalThreadStateException("enter() invoked from a Java Thread");
        }
    }

    private static native ImmortalMemory initImmortal(long var0);

    protected void finalize() throws Throwable {
        System.out.println("Inside immortal memory's finalize");
        super.finalize();
    }

    private void init2() {
    }
}

