/*
 * Decompiled with CFR 0.152.
 */
package java.text;

final class CompactCharArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private char[] values;
    private short[] indices;
    private int[] hashes;
    private boolean isCompact;

    public CompactCharArray() {
        this('\u0000');
    }

    public CompactCharArray(char c) {
        int n;
        this.values = new char[65536];
        this.indices = new short[512];
        this.hashes = new int[512];
        for (n = 0; n < 65536; ++n) {
            this.values[n] = c;
        }
        for (n = 0; n < 512; ++n) {
            this.indices[n] = (short)(n << 7);
            this.hashes[n] = 0;
        }
        this.isCompact = false;
    }

    public CompactCharArray(short[] sArray, char[] cArray) {
        if (sArray.length != 512) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        for (int i = 0; i < 512; ++i) {
            short s = sArray[i];
            if (s >= 0 && s < cArray.length + 128) continue;
            throw new IllegalArgumentException("Index out of bounds.");
        }
        this.indices = sArray;
        this.values = cArray;
        this.isCompact = true;
    }

    public char elementAt(char c) {
        return this.values[(this.indices[c >> 7] & 0xFFFF) + (c & 0x7F)];
    }

    public void setElementAt(char c, char c2) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c] = c2;
        this.touchBlock(c >> 7, c2);
    }

    public void setElementAt(char n, char c, char c2) {
        if (this.isCompact) {
            this.expand();
        }
        for (int i = n; i <= c; ++i) {
            this.values[i] = c2;
            this.touchBlock(i >> 7, c2);
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int n = 0;
            int n2 = 0;
            int n3 = -1;
            int n4 = 0;
            while (n4 < this.indices.length) {
                this.indices[n4] = -1;
                boolean bl = this.blockTouched(n4);
                if (!bl && n3 != -1) {
                    this.indices[n4] = n3;
                } else {
                    int n5 = 0;
                    int n6 = 0;
                    n6 = 0;
                    while (n6 < n) {
                        if (this.hashes[n4] == this.hashes[n6] && CompactCharArray.arrayRegionMatches(this.values, n2, this.values, n5, 128)) {
                            this.indices[n4] = (short)n5;
                        }
                        ++n6;
                        n5 += 128;
                    }
                    if (this.indices[n4] == -1) {
                        System.arraycopy(this.values, n2, this.values, n5, 128);
                        this.indices[n4] = (short)n5;
                        this.hashes[n6] = this.hashes[n4];
                        ++n;
                        if (!bl) {
                            n3 = (short)n5;
                        }
                    }
                }
                ++n4;
                n2 += 128;
            }
            n4 = n * 128;
            char[] cArray = new char[n4];
            System.arraycopy(this.values, 0, cArray, 0, n4);
            this.values = cArray;
            this.isCompact = true;
            this.hashes = null;
        }
    }

    static final boolean arrayRegionMatches(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        int n4 = n + n3;
        int n5 = n2 - n;
        for (int i = n; i < n4; ++i) {
            if (cArray[i] == cArray2[i + n5]) continue;
            return false;
        }
        return true;
    }

    private final void touchBlock(int n, int n2) {
        this.hashes[n] = this.hashes[n] + (n2 << 1) | 1;
    }

    private final boolean blockTouched(int n) {
        return this.hashes[n] != 0;
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    public char[] getStringArray() {
        return this.values;
    }

    public Object clone() {
        try {
            CompactCharArray compactCharArray = (CompactCharArray)super.clone();
            compactCharArray.values = (char[])this.values.clone();
            compactCharArray.indices = (short[])this.indices.clone();
            if (this.hashes != null) {
                compactCharArray.hashes = (int[])this.hashes.clone();
            }
            return compactCharArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactCharArray compactCharArray = (CompactCharArray)object;
        for (int i = 0; i < 65536; ++i) {
            if (this.elementAt((char)i) == compactCharArray.elementAt((char)i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = Math.min(3, this.values.length / 16);
        for (int i = 0; i < this.values.length; i += n2) {
            n = n * 37 + this.values[i];
        }
        return n;
    }

    private void expand() {
        if (this.isCompact) {
            int n;
            char[] cArray = new char[65536];
            this.hashes = new int[512];
            for (n = 0; n < 65536; ++n) {
                char c;
                cArray[n] = c = this.elementAt((char)n);
                this.touchBlock(n >> 7, c);
            }
            for (n = 0; n < 512; ++n) {
                this.indices[n] = (short)(n << 7);
            }
            this.values = null;
            this.values = cArray;
            this.isCompact = false;
        }
    }

    private char getArrayValue(int n) {
        return this.values[n];
    }

    private short getIndexArrayValue(int n) {
        return this.indices[n];
    }
}

