/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.BitSet;

public class URLEncoder {
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;

    private URLEncoder() {
    }

    public static String encode(String string) {
        int n = 10;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        for (int i = 0; i < string.length(); ++i) {
            int n2 = string.charAt(i);
            if (dontNeedEncoding.get(n2)) {
                if (n2 == 32) {
                    n2 = 43;
                }
                stringBuffer.append((char)n2);
                continue;
            }
            try {
                outputStreamWriter.write(n2);
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                byteArrayOutputStream.reset();
                continue;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            for (int j = 0; j < byArray.length; ++j) {
                stringBuffer.append('%');
                char c = Character.forDigit(byArray[j] >> 4 & 0xF, 16);
                if (Character.isLetter(c)) {
                    c = (char)(c - 32);
                }
                stringBuffer.append(c);
                c = Character.forDigit(byArray[j] & 0xF, 16);
                if (Character.isLetter(c)) {
                    c = (char)(c - 32);
                }
                stringBuffer.append(c);
            }
            byteArrayOutputStream.reset();
        }
        return stringBuffer.toString();
    }

    static {
        int n;
        dontNeedEncoding = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            dontNeedEncoding.set(n);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }
}

