/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import edu.purdue.scj.VMSupport;
import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import javax.realtime.HighResolutionTime;
import javax.safetycritical.CyclicSchedule;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionManager;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.Safelet;
import javax.safetycritical.SingleMissionSequencer;
import javax.safetycritical.StorageParameters;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed
public abstract class CyclicExecutive
extends Mission
implements Safelet {
    private MissionSequencer _sequencer;
    private static final int NANOS_PER_MILLI = 1000000;

    @SCJAllowed
    public CyclicExecutive(StorageParameters storageParameters) {
        this._sequencer = new SingleMissionSequencer(null, storageParameters, this);
    }

    @SCJAllowed
    public MissionSequencer getSequencer() {
        return this._sequencer;
    }

    @SCJAllowed
    public abstract CyclicSchedule getSchedule(PeriodicEventHandler[] var1);

    protected final void exec(MissionManager missionManager) {
        if (missionManager.getHandlers() == 0) {
            return;
        }
        PeriodicEventHandler[] periodicEventHandlerArray = new PeriodicEventHandler[missionManager.getHandlers()];
        PeriodicEventHandler periodicEventHandler = (PeriodicEventHandler)missionManager.getFirstHandler();
        int n = 0;
        while (periodicEventHandler != null) {
            periodicEventHandlerArray[n] = periodicEventHandler;
            periodicEventHandler = (PeriodicEventHandler)periodicEventHandler.getNext();
            ++n;
        }
        CyclicSchedule cyclicSchedule = this.getSchedule(periodicEventHandlerArray);
        CyclicSchedule.Frame[] frameArray = cyclicSchedule.getFrames();
        Wrapper wrapper = new Wrapper();
        AbsoluteTime absoluteTime = Clock.getRealtimeClock().getTime();
        block1: while (this._phase == 1) {
            for (int i = 0; i < frameArray.length; ++i) {
                absoluteTime.add(frameArray[i].getDuration(), absoluteTime);
                PeriodicEventHandler[] periodicEventHandlerArray2 = frameArray[i].getHandlers();
                for (int j = 0; j < periodicEventHandlerArray2.length; ++j) {
                    if (periodicEventHandlerArray2[j] == null) continue;
                    wrapper._handler = periodicEventHandlerArray2[j];
                    wrapper.runInItsInitArea();
                }
                if (this._phase != 1) continue block1;
                CyclicExecutive.waitForNextFrame(absoluteTime);
            }
        }
    }

    private static void waitForNextFrame(AbsoluteTime absoluteTime) {
        int n;
        while ((n = VMSupport.delayCurrentThreadAbsolute(CyclicExecutive.toNanos(absoluteTime))) != -1 && n != 0) {
        }
    }

    static long toNanos(HighResolutionTime highResolutionTime) {
        long l = highResolutionTime.getMilliseconds() * 1000000L + (long)highResolutionTime.getNanoseconds();
        if (l < 0L) {
            l = Long.MAX_VALUE;
        }
        return l;
    }

    class Wrapper
    implements Runnable {
        PeriodicEventHandler _handler = null;

        Wrapper() {
        }

        void runInItsInitArea() {
            if (this._handler != null) {
                this._handler.getInitArea().enter(this);
            }
        }

        public void run() {
            try {
                this._handler.handleEvent();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

