/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AbsoluteTime;
import javax.realtime.HighResolutionTime;
import javax.realtime.RelativeTime;
import javax.realtime.ReleaseParameters;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;
import javax.safetycritical.annotate.SCJRestricted;

@SCJAllowed
public class PeriodicParameters
extends ReleaseParameters {
    protected HighResolutionTime _start;
    protected final RelativeTime _period;

    @SCJAllowed
    public PeriodicParameters(HighResolutionTime highResolutionTime, RelativeTime relativeTime) {
        this._start = highResolutionTime == null ? new AbsoluteTime(0L, 0) : highResolutionTime;
        if (relativeTime == null || relativeTime.isNegative()) {
            throw new IllegalArgumentException("Need a period > 0");
        }
        this._period = new RelativeTime(relativeTime);
    }

    @SCJAllowed
    @SCJRestricted
    public HighResolutionTime getStart() {
        return this._start;
    }

    @SCJAllowed(value=Level.LEVEL_1)
    @SCJRestricted
    public RelativeTime getPeriod() {
        return this._period;
    }

    long getPeriodNanos() {
        return this._period.toNanos();
    }
}

