/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.MemoryArea;
import javax.realtime.RealtimeThread;
import javax.safetycritical.ManagedMemory;
import javax.safetycritical.MissionManager;
import javax.safetycritical.MissionMemory;

public abstract class Mission {
    boolean _terminateAll;
    volatile int _phase = -1;
    private Object _quitMonitor = new Object();

    public static Mission getCurrentMission() {
        MemoryArea memoryArea = RealtimeThread.getCurrentMemoryArea();
        if (!(memoryArea instanceof ManagedMemory)) {
            throw new Error("Cannot get current mission in non-managed memory");
        }
        return ((ManagedMemory)memoryArea).getManager().getMission();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestTermination() {
        if (this._phase != -2) {
            this._phase = -2;
            Object object = this._quitMonitor;
            synchronized (object) {
                this._quitMonitor.notify();
            }
        }
    }

    public void requestSequenceTermination() {
        this._terminateAll = true;
        this.requestTermination();
    }

    final void run() {
        MissionMemory missionMemory = (MissionMemory)RealtimeThread.getCurrentMemoryArea();
        MissionManager missionManager = new MissionManager(this);
        missionMemory.setManager(missionManager);
        this._terminateAll = false;
        this._phase = 0;
        this.initialize();
        this._phase = 1;
        this.exec(missionManager);
        this._phase = 2;
        this.cleanup();
        this._phase = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exec(MissionManager missionManager) {
        missionManager.startAll();
        Object object = this._quitMonitor;
        synchronized (object) {
            try {
                this._quitMonitor.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        missionManager.cleanAll();
    }

    public abstract long missionMemorySize();

    protected abstract void initialize();

    protected void cleanup() {
    }

    public static class Phase {
        public static final int INITIAL = 0;
        public static final int EXECUTE = 1;
        public static final int CLEANUP = 2;
        public static final int INACTIVE = -1;
        public static final int TERMINATED = -2;
    }
}

