/**
 * 
 * @author Frank Zeyda, Kun Wei
 */
package cdx;

import javacp.util.ArrayList;
import javacp.util.LinkedList;
import javacp.util.List;

/**
 * This class evenly distributes lists of motions which may be collided to
 * each element of the shared variable `parts', so that each DetectorHandler
 * can retrieve the related list regarding to its ID.
 */

public class Partition {
  /** The Array of lists for storing lists of motions. */
  private final List[] parts;
  /** The index of parts */
  private int counter;

  /**
   * Constructor
   * @param n  the number of DetectorHandlers
   */
  public Partition(int n) {
    parts = new ArrayList[n];
    for (int i = 0; i < n; i++) {
      parts[i] = new ArrayList(
      	/* The length of a list depends on the size of voxels */
        Constants.voxels(Constants.GOOD_VOXEL_SIZE) / n + 1);
    }
    counter = 0;
  }

  
  /** Clear the shared `parts'. */
  public synchronized void clear() {
    for (int i = 0; i < parts.length; i++) {
      parts[i].clear();
    }
    counter = 0;
  }

  /**
   * Method to add a list of motions in parts[i].
   * @param motions  a list of motions which may be collided in a voxel
   */
  public synchronized void recordMotionList(List motions) {
    parts[counter].add(motions);
    counter = (counter + 1) % parts.length;
  }

  /** Return an ID for a DetectorHandler. */
  public synchronized List getDetectorWork(int id) {
    return parts[id-1];
  }
}
