/**
 * @author Frank Zeyda, Kun Wei
 */
package cdx;

import javax.realtime.PriorityParameters;

import javax.safetycritical.AperiodicEvent;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.AperiodicParameters;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageParameters;

/**
 * OutputCollisionsHandler outputs the number of detected collisions to an
 * external device. For the purpose of the simulation, we merely print it on
 * the screen.
 */
public class OutputCollisionsHandler extends AperiodicEventHandler {
  /** The current mission */
  public final CDxMission mission;

  /**
   * Constructor
   * @param mission       the current mission
   * @param event_bound   the event to release this handler
   */
  public OutputCollisionsHandler(
      CDxMission mission,
      AperiodicEvent event_bound) {
    super(
      new PriorityParameters(
        PriorityScheduler.instance().getMaxPriority()),
      new AperiodicParameters(null, null),
      new StorageParameters(32768, 4096, 4096),
      event_bound, "OutputCollisionsHandler");
    this.mission = mission;
  }

  /** Update the number of collisions in the mission.  */
  public void handleEvent() {
    /* The the collisions result form the CDxMission class. */
    int colls = mission.getColls();

    /* In a real system write collisions to an external device here. */
    System.out.println(colls + " collisions have been detected!");
  }
}
