/**
 * @author Kun Wei, Frank Zeyda
 */
package cdx;

/**
 * This class is used to pre-allocate Motion objects in mission memory.
 */
public class MotionFactory {
  
  /** The motion store that is an array of motions */
  private final Motion[] store;

  /** The index for the motions*/
  private int index;

  /**
   * Constructor
   * @param size  the capacity of this store
   */
  public MotionFactory(int size) {
    store = new Motion[size];
    for (int i = 0; i < store.length; i++) {
      store[i] = new Motion();
    }
    index = 0;
  }

  /** 
   * Return a pre-allocated instance of the Motionclass.
   * The program exits if exceeding the storage capacity
   */
  public Motion getNewMotion() {
    if (index < store.length) {
      return store[index++];
    }
    else {
      Error.abort("Exceeding storage capacity in MotionFactory.");
      return null; // Never reached.
    }
  }

  /** Restore the index */
  public void clear() {
    index = 0;
  }
}
