public class TakeOffMission extends Mission implements LandingGearUser
{
	final double SAFE_AIRSPEED_THRESHOLD = 10.00;
	final double TAKEOFF_ALTITUDE = 10.00;

	private MainMission controllingMission;

	private boolean abort = false;

	private boolean landingGearDeployed;

	public TakeOffMission(MainMission controllingMission)
	{
		this.controllingMission = controllingMission;
	}

	@Override
	protected void initialize()
	{
		StorageParameters storageParametersSchedulable = new StorageParameters(
		Const.PRIVATE_MEM_DEFAULT - 30 * 1000,
		Const.PRIVATE_MEM_DEFAULT - 30 * 1000,
		Const.IMMORTAL_MEM_DEFAULT - 50 * 1000,
		Const.MISSION_MEM_DEFAULT - 100 * 1000);

		LandingGearHandler landingGearHandler = new LandingGearHandler(
		new PriorityParameters(5), new AperiodicParameters(),
		storageParametersSchedulable, "Landing Gear Handler", this);

		landingGearHandler.register();

		TakeOffMonitor takeOffMonitor = new TakeOffMonitor(
		new PriorityParameters(5), new PeriodicParameters(
		new RelativeTime(0, 0), new RelativeTime(500, 0)),
		storageParametersSchedulable, controllingMission, this, TAKEOFF_ALTITUDE,
		landingGearHandler);

		takeOffMonitor.register();

		TakeOffFailureHandler takeOffFailureHandler = new TakeOffFailureHandler(
		new PriorityParameters(5), new AperiodicParameters(),
		storageParametersSchedulable, "Take Off Handler", controllingMission, this,
		SAFE_AIRSPEED_THRESHOLD);

		takeOffFailureHandler.register();
	}

	@Override
	public long missionMemorySize()
	{
		return Const.MISSION_MEM_DEFAULT;
	}

	public void takeOffAbort()
	{
		abort = true;
	}

	@Override
	public synchronized void deployLandingGear()
	{
		landingGearDeployed = true;
	}

	@Override
	public boolean cleanUp()
	{
		Console.println("Take Off Mission Cleanup, Returning " + !abort);
		return !abort;
	}

	@Override
	public void stowLandingGear()
	{
		landingGearDeployed = false;
	}

	@Override
	public boolean isLandingGearDeployed()
	{
		return landingGearDeployed;
	}
}
