pragma Profile (Ravenscar);
with Actuators; use Actuators;
--with Simulator_Interface; use Simulator_Interface;
with Interfaces.C; use Interfaces.C;
with Ada.Text_IO; use Ada.Text_IO;
with Configuration; use Configuration;
with Ada.Real_Time; use Ada.Real_Time;
with Ada.Exceptions; use Ada.Exceptions;
with Ada.Numerics.Float_Random; use Ada.Numerics.Float_Random; 


package body Timers is


  protected body Timer is
    procedure Atrium_Pace_On(E : in out Timing_Event) is
    begin
      -- pace current on
      Put_line("A paced");
      Pace_A_On;
      Set_Handler(General_Timeouts, Clock+Pulse_Duration, Atrium_Pace_Off'Access);
    end;

    procedure Atrium_Pace_Off(E : in out Timing_Event) is
    begin
      --pace current off
      Pace_A_Off;
      Set_Handler(General_Timeouts, Clock+AVI, Ventricle_Pace_On'Access);
      Reading := Ventricle;
    end;

    procedure Ventricle_Pace_On(E  : in out Timing_Event) is
      Set : Boolean;
    begin
      --Put_line("V paced");
      Pace_V_On;
      if IntrinsicV_Sensed then
        --Put_line("Pacing after intrinsic sense error");
        IntrinsicV_Sensed := False;
      end if;
      -- pace current on
      Cancel_Handler(Sensor_Readings, Set);
      pragma assert(Set);
      Set_Handler(General_Timeouts, Clock+Pulse_Duration , Ventricle_Pace_Off'Access);
    end;

    procedure Ventricle_Pace_Off(E  : in out Timing_Event) is
    begin
      --pace current off
      Pace_V_Off;
      Set_Handler(General_Timeouts, Clock+PVARP , PVARP_Countdown'Access);
      Reading := Atrium;
    end;


    procedure PVARP_Countdown(E : in out Timing_Event) is
      res : Float;
      RNG : Generator; 
    begin

      --Put_line("A sensing");
      --res := Read_Atrium_Data;
      Reset(RNG);
      res := Random(RNG); 
      --Put_line("Sense A < 0.30");
      --Put_line(float'Image(res));
      if res > 0.3 then
        Put_line("Intrinsic activity sensed in A");
        --Put_line("Sensed Value in A >= 0.30");

        --Write_Atrium_Data(3);
        Set_Handler(General_Timeouts, Clock+AVI, Ventricle_Pace_On'Access);
        Reading := Ventricle;
      else
        Reading := Atrium;
        Set_Handler(General_Timeouts, Clock+VAI, Atrium_Pace_On'Access);
      end if;
      Set_Handler(Sensor_Readings, Sensor_Period, Sensor_Read'Access);
    end;


    procedure Sensor_Read(E : in out Timing_Event) is
      res : Float;
      RNG : Generator; 
    begin

      if Reading = Atrium then
        --res := Read_Atrium_Data;
      Reset(RNG);   
      res := Random(RNG); 
        --Put("sensing A ");
        --Put_line(double'Image(res));
        --Put_line("Sense A < 0.30");
        --Put_line(float'Image(res));

        if res > 0.3 then
           --Put_line("Sensed Value in A >= 0.30");
           Put_line("Intrinsic activity sensed in A");
           --Write_Atrium_Data(3);
          Set_Handler(General_Timeouts, Clock+AVI, Ventricle_Pace_On'Access);
          Reading := Ventricle;
        end if;
        Set_Handler(Timers.Sensor_Readings, Sensor_Period, Timer.Sensor_Read'Access);
      else -- reading ventricle
        --res := Read_Ventricle_Data;
        Reset(RNG);
        res := Random(RNG); 
        --Put("Sense V < 0.90"); 
        --Put_line(float'Image(res));
        if res >= 0.9 then
          Put_line("Intrinsic activity sensed in V");
          --Write_Ventricle_Data(4);
          Set_Handler(General_Timeouts, Clock+PVARP , PVARP_Countdown'Access);
          Reading := Atrium;
          IntrinsicV_Sensed := True;
        else
          IntrinsicV_Sensed := False;
          Set_Handler(Timers.Sensor_Readings, Sensor_Period, Timer.Sensor_Read'Access);
        end if;
      end if;
    end Sensor_Read;
  end Timer;

end Timers;
